/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers.macros;

import com.google.common.base.Preconditions;
import com.nesscomputing.mojo.numbers.AbstractNumbersMojo;
import com.nesscomputing.mojo.numbers.ValueProvider;
import com.nesscomputing.mojo.numbers.beans.IWFCEnum;
import com.nesscomputing.mojo.numbers.beans.MacroDefinition;
import com.nesscomputing.mojo.numbers.macros.MacroType;
import com.nesscomputing.mojo.numbers.util.Log;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MacroType.class, hint="scm")
public class ScmMacro
implements MacroType {
    private static final Log LOG = Log.findLog();
    public ScmManager scmManager = null;

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    @Override
    public String getValue(@Nonnull MacroDefinition macroDefinition, @Nonnull ValueProvider valueProvider, @Nonnull AbstractNumbersMojo mojo) throws Exception {
        String rev;
        Preconditions.checkState((mojo != null ? 1 : 0) != 0, (Object)"inserted mojo is null!");
        Properties props = macroDefinition.getProperties();
        ScmRepository scmRepo = this.getScmRepository(mojo.getProject(), mojo.getSettings(), props);
        String revision = props.getProperty("revision");
        String branch = props.getProperty("branch");
        String tag = props.getProperty("tag");
        ScmRevision scmRevision = revision == null ? null : new ScmRevision(revision);
        ScmBranch scmBranch = branch == null ? null : new ScmBranch(branch);
        ScmTag scmTag = tag == null ? null : new ScmTag(tag);
        ScmFileSet fileSet = new ScmFileSet(mojo.getBasedir());
        ChangeLogScmRequest req = new ChangeLogScmRequest(scmRepo, fileSet);
        if (branch != null) {
            rev = scmBranch.getName();
            req.setScmBranch(scmBranch);
        } else {
            ScmVersion scmVersion = (ScmVersion)ObjectUtils.defaultIfNull((Object)scmTag, (Object)scmRevision);
            rev = scmVersion != null ? scmVersion.getName() : "<unset>";
            req.setEndRevision(scmVersion);
        }
        ChangeLogScmResult result = this.scmManager.changeLog(req);
        IWFCEnum.checkState(macroDefinition.getOnMissingProperty(), result.isSuccess(), "scm revision '" + rev + "'");
        if (!result.isSuccess()) {
            return "";
        }
        List changeSets = result.getChangeLog().getChangeSets();
        Preconditions.checkState((changeSets != null && changeSets.size() > 0 ? 1 : 0) != 0, (Object)"no change sets found!");
        return ((ChangeSet)changeSets.get(0)).getRevision();
    }

    public ScmRepository getScmRepository(MavenProject project, Settings settings, Properties props) throws ScmException {
        ScmRepository repository;
        Scm scm = project.getScm();
        Preconditions.checkState((scm != null ? 1 : 0) != 0, (Object)"No scm element in the project found!");
        try {
            ScmProviderRepositoryWithHost repo;
            Server server;
            repository = this.scmManager.makeScmRepository(this.getConnectionUrl(scm, props));
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost && (server = settings.getServer((repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository()).getHost())) != null) {
                repo.setUser(server.getUsername());
                repo.setPassword(server.getPassword());
                repo.setPrivateKey(server.getPrivateKey());
                repo.setPassphrase(server.getPassphrase());
            }
        }
        catch (ScmRepositoryException e) {
            if (!e.getValidationMessages().isEmpty()) {
                for (String msg : e.getValidationMessages()) {
                    LOG.error(msg);
                }
            }
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    public String getConnectionUrl(Scm scm, Properties props) {
        boolean requireDeveloperConnection = BooleanUtils.toBoolean((String)props.getProperty("requireDeveloperConnection"));
        if (StringUtils.isNotBlank((CharSequence)scm.getConnection()) && !requireDeveloperConnection) {
            String url = ObjectUtils.toString((Object)scm.getConnection(), (String)scm.getDeveloperConnection());
            Preconditions.checkState((url != null ? 1 : 0) != 0, (Object)"no scm url found!");
            return url;
        }
        String url = scm.getDeveloperConnection();
        Preconditions.checkState((url != null ? 1 : 0) != 0, (Object)"no scm developer url found!");
        return url;
    }
}

