/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j;

import org.apache.commons.lang3.StringUtils;

public enum SyslogFacility {
    kern(0),
    user(1),
    mail(2),
    daemon(3),
    auth(4),
    syslog(5),
    lpr(6),
    news(7),
    uucp(8),
    cron(9),
    authpriv(10),
    ftp(11),
    ntp(12),
    audit(13),
    alert(14),
    clock(15),
    local0(16),
    local1(17),
    local2(18),
    local3(19),
    local4(20),
    local5(21),
    local6(22),
    local7(23);

    public static final SyslogFacility DEFAULT;
    private final int value;

    private SyslogFacility(int value) {
        this.value = value << 3;
    }

    public int getValue() {
        return this.value;
    }

    public static final SyslogFacility forName(String name) {
        for (SyslogFacility facility : SyslogFacility.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)facility.name(), (CharSequence)name)) continue;
            return facility;
        }
        return null;
    }

    public static final SyslogFacility forValue(int value) {
        for (SyslogFacility facility : SyslogFacility.values()) {
            if (facility.getValue() != value) continue;
            return facility;
        }
        return null;
    }

    static {
        DEFAULT = user;
    }
}

