/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.nesscomputing.syslog4j.SyslogBackLogHandlerIF;
import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogMessageModifierIF;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslogConfigIF;
import com.nesscomputing.syslog4j.impl.AbstractSyslogWriter;
import com.nesscomputing.syslog4j.impl.backlog.printstream.SystemErrSyslogBackLogHandler;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.Charset;
import java.util.List;

public abstract class AbstractSyslogConfig
implements AbstractSyslogConfigIF {
    protected static final List<SyslogBackLogHandlerIF> defaultBackLogHandlers = Lists.newArrayList();
    protected SyslogFacility facility = SyslogFacility.DEFAULT;
    protected Charset charSet = Charsets.UTF_8;
    protected String ident = "";
    protected String localName = null;
    protected boolean sendLocalTimestamp = true;
    protected boolean sendLocalName = true;
    protected boolean includeIdentInMessageModifier = false;
    protected boolean throwExceptionOnWrite = false;
    protected boolean throwExceptionOnInitialize = true;
    protected int maxMessageLength = 1024;
    protected byte[] splitMessageBeginText = "...".getBytes(Charsets.UTF_8);
    protected byte[] splitMessageEndText = "...".getBytes(Charsets.UTF_8);
    protected List<SyslogMessageModifierIF> messageModifiers = null;
    protected List<SyslogBackLogHandlerIF> backLogHandlers = null;
    protected boolean threaded = true;
    protected boolean useDaemonThread = true;
    protected int threadPriority = -1;
    protected long threadLoopInterval = 500L;
    protected int writeRetries = 2;
    protected long maxShutdownWait = 30000L;
    protected boolean truncateMessage = false;
    protected boolean useStructuredData = false;

    @Override
    public abstract Class<? extends SyslogIF> getSyslogClass();

    @Override
    public Charset getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(Charset charSet) {
        this.charSet = charSet;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public boolean isThrowExceptionOnWrite() {
        return this.throwExceptionOnWrite;
    }

    @Override
    public void setThrowExceptionOnWrite(boolean throwExceptionOnWrite) {
        this.throwExceptionOnWrite = throwExceptionOnWrite;
    }

    @Override
    public boolean isThrowExceptionOnInitialize() {
        return this.throwExceptionOnInitialize;
    }

    @Override
    public void setThrowExceptionOnInitialize(boolean throwExceptionOnInitialize) {
        this.throwExceptionOnInitialize = throwExceptionOnInitialize;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getSplitMessageBeginText() {
        return this.splitMessageBeginText;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setSplitMessageBeginText(byte[] splitMessageBeginText) {
        this.splitMessageBeginText = splitMessageBeginText;
    }

    public void setSplitMessageBeginText(String splitMessageBeginText) throws SyslogRuntimeException {
        this.splitMessageBeginText = SyslogUtility.getBytes(this, splitMessageBeginText);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getSplitMessageEndText() {
        return this.splitMessageEndText;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setSplitMessageEndText(byte[] splitMessageEndText) {
        this.splitMessageEndText = splitMessageEndText;
    }

    public void setSplitMessageEndText(String splitMessageEndText) throws SyslogRuntimeException {
        this.splitMessageEndText = SyslogUtility.getBytes(this, splitMessageEndText);
    }

    @Override
    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Override
    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    @Override
    public boolean isSendLocalTimestamp() {
        return this.sendLocalTimestamp;
    }

    @Override
    public void setSendLocalTimestamp(boolean sendLocalTimestamp) {
        this.sendLocalTimestamp = sendLocalTimestamp;
    }

    @Override
    public boolean isSendLocalName() {
        return this.sendLocalName;
    }

    @Override
    public void setSendLocalName(boolean sendLocalName) {
        this.sendLocalName = sendLocalName;
    }

    @Override
    public SyslogFacility getFacility() {
        return this.facility;
    }

    @Override
    public void setFacility(SyslogFacility facility) {
        this.facility = facility;
    }

    @Override
    public String getIdent() {
        return this.ident;
    }

    @Override
    public void setIdent(String ident) {
        this.ident = ident;
    }

    protected synchronized List<SyslogMessageModifierIF> _getMessageModifiers() {
        if (this.messageModifiers == null) {
            this.messageModifiers = Lists.newArrayList();
        }
        return this.messageModifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageModifier(SyslogMessageModifierIF messageModifier) {
        List<SyslogMessageModifierIF> _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List<SyslogMessageModifierIF> list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            _messageModifiers.add(messageModifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMessageModifier(int index, SyslogMessageModifierIF messageModifier) {
        List<SyslogMessageModifierIF> _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List<SyslogMessageModifierIF> list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            try {
                _messageModifiers.add(index, messageModifier);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new SyslogRuntimeException(ioobe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageModifier(SyslogMessageModifierIF messageModifier) {
        List<SyslogMessageModifierIF> _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List<SyslogMessageModifierIF> list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            _messageModifiers.remove(messageModifier);
        }
    }

    public List<SyslogMessageModifierIF> getMessageModifiers() {
        return this.messageModifiers;
    }

    public void setMessageModifiers(List<SyslogMessageModifierIF> messageModifiers) {
        this.messageModifiers = messageModifiers;
    }

    @Override
    public void removeAllMessageModifiers() {
        if (this.messageModifiers == null || this.messageModifiers.isEmpty()) {
            return;
        }
        this.messageModifiers.clear();
    }

    protected synchronized List<SyslogBackLogHandlerIF> _getBackLogHandlers() {
        if (this.backLogHandlers == null) {
            this.backLogHandlers = Lists.newArrayList();
        }
        return this.backLogHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        List<SyslogBackLogHandlerIF> _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List<SyslogBackLogHandlerIF> list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            backLogHandler.initialize();
            _backLogHandlers.add(backLogHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertBackLogHandler(int index, SyslogBackLogHandlerIF backLogHandler) {
        List<SyslogBackLogHandlerIF> _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List<SyslogBackLogHandlerIF> list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            try {
                backLogHandler.initialize();
                _backLogHandlers.add(index, backLogHandler);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new SyslogRuntimeException(ioobe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        List<SyslogBackLogHandlerIF> _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List<SyslogBackLogHandlerIF> list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            _backLogHandlers.remove(backLogHandler);
        }
    }

    public List<SyslogBackLogHandlerIF> getBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.size() < 1) {
            return defaultBackLogHandlers;
        }
        return this.backLogHandlers;
    }

    public void setBackLogHandlers(List<SyslogBackLogHandlerIF> backLogHandlers) {
        this.backLogHandlers = backLogHandlers;
    }

    @Override
    public void removeAllBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.isEmpty()) {
            return;
        }
        this.backLogHandlers.clear();
    }

    @Override
    public boolean isIncludeIdentInMessageModifier() {
        return this.includeIdentInMessageModifier;
    }

    @Override
    public void setIncludeIdentInMessageModifier(boolean includeIdentInMessageModifier) {
        this.includeIdentInMessageModifier = includeIdentInMessageModifier;
    }

    @Override
    public boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    @Override
    public boolean isUseDaemonThread() {
        return this.useDaemonThread;
    }

    @Override
    public void setUseDaemonThread(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    @Override
    public long getThreadLoopInterval() {
        return this.threadLoopInterval;
    }

    @Override
    public void setThreadLoopInterval(long threadLoopInterval) {
        this.threadLoopInterval = threadLoopInterval;
    }

    @Override
    public long getMaxShutdownWait() {
        return this.maxShutdownWait;
    }

    @Override
    public void setMaxShutdownWait(long maxShutdownWait) {
        this.maxShutdownWait = maxShutdownWait;
    }

    @Override
    public int getWriteRetries() {
        return this.writeRetries;
    }

    @Override
    public void setWriteRetries(int writeRetries) {
        this.writeRetries = writeRetries;
    }

    @Override
    public boolean isTruncateMessage() {
        return this.truncateMessage;
    }

    @Override
    public void setTruncateMessage(boolean truncateMessage) {
        this.truncateMessage = truncateMessage;
    }

    @Override
    public boolean isUseStructuredData() {
        return this.useStructuredData;
    }

    @Override
    public void setUseStructuredData(boolean useStructuredData) {
        this.useStructuredData = useStructuredData;
    }

    @Override
    public Class<? extends AbstractSyslogWriter> getSyslogWriterClass() {
        return null;
    }

    static {
        defaultBackLogHandlers.add(new SystemErrSyslogBackLogHandler());
    }
}

