/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl;

import com.google.common.collect.Lists;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslog;
import com.nesscomputing.syslog4j.impl.AbstractSyslogConfigIF;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSyslogWriter
implements Runnable {
    protected AbstractSyslog syslog = null;
    protected List<byte[]> queuedMessages = null;
    protected Thread thread = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected boolean shutdown = false;

    public void initialize(AbstractSyslog abstractSyslog) {
        this.syslog = abstractSyslog;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)this.syslog.getConfig();
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must implement interface AbstractSyslogConfigIF", new Object[0]);
        }
        if (this.syslogConfig.isThreaded()) {
            this.queuedMessages = Lists.newLinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(SyslogLevel level, byte[] message) {
        List<byte[]> list = this.queuedMessages;
        synchronized (list) {
            if (this.syslogConfig.getMaxQueueSize() == -1 || this.queuedMessages.size() < this.syslogConfig.getMaxQueueSize()) {
                this.queuedMessages.add(message);
            } else {
                this.syslog.backLog(level, SyslogUtility.newString(this.syslogConfig, message), "MaxQueueSize (" + this.syslogConfig.getMaxQueueSize() + ") reached");
            }
        }
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public boolean hasThread() {
        return this.thread != null && this.thread.isAlive();
    }

    public abstract void write(byte[] var1);

    public abstract void flush();

    public abstract void shutdown();

    protected abstract void runCompleted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown || !this.queuedMessages.isEmpty()) {
            LinkedList queuedMessagesCopy = null;
            List<byte[]> list = this.queuedMessages;
            synchronized (list) {
                queuedMessagesCopy = Lists.newLinkedList(this.queuedMessages);
                this.queuedMessages.clear();
            }
            if (queuedMessagesCopy != null) {
                while (!queuedMessagesCopy.isEmpty()) {
                    byte[] message = (byte[])queuedMessagesCopy.remove(0);
                    try {
                        this.write(message);
                        this.syslog.setBackLogStatus(false);
                    }
                    catch (SyslogRuntimeException sre) {
                        this.syslog.backLog(SyslogLevel.INFO, SyslogUtility.newString(this.syslog.getConfig(), message), sre);
                    }
                }
            }
            SyslogUtility.sleep(this.syslogConfig.getThreadLoopInterval());
        }
        this.runCompleted();
    }
}

