/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.backlog.log4j;

import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;

public class Log4jSyslogBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected Logger logger = null;
    protected Level downLevel = Level.WARN;
    protected Level upLevel = Level.WARN;

    public Log4jSyslogBackLogHandler(Logger logger) throws SyslogRuntimeException {
        this.logger = logger;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Logger logger, boolean appendReason) {
        this.logger = logger;
        this.appendReason = appendReason;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Class<?> loggerClass) {
        if (loggerClass == null) {
            throw new SyslogRuntimeException("loggerClass cannot be null", new Object[0]);
        }
        this.logger = Logger.getLogger(loggerClass);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Class<?> loggerClass, boolean appendReason) {
        if (loggerClass == null) {
            throw new SyslogRuntimeException("loggerClass cannot be null", new Object[0]);
        }
        this.logger = Logger.getLogger(loggerClass);
        this.appendReason = appendReason;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null", new Object[0]);
        }
        this.logger = Logger.getLogger((String)loggerName);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName, boolean appendReason) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null", new Object[0]);
        }
        this.logger = Logger.getLogger((String)loggerName);
        this.appendReason = appendReason;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName, LoggerFactory loggerFactory) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null", new Object[0]);
        }
        if (loggerFactory == null) {
            throw new SyslogRuntimeException("loggerFactory cannot be null", new Object[0]);
        }
        this.logger = Logger.getLogger((String)loggerName, (LoggerFactory)loggerFactory);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName, LoggerFactory loggerFactory, boolean appendReason) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null", new Object[0]);
        }
        if (loggerFactory == null) {
            throw new SyslogRuntimeException("loggerFactory cannot be null", new Object[0]);
        }
        this.logger = Logger.getLogger((String)loggerName, (LoggerFactory)loggerFactory);
        this.appendReason = appendReason;
        this.initialize();
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
        if (this.logger == null) {
            throw new SyslogRuntimeException("logger cannot be null", new Object[0]);
        }
    }

    protected static Level getLog4jLevel(SyslogLevel level) {
        if (level == null) {
            return Level.WARN;
        }
        switch (level) {
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case NOTICE: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case CRITICAL: {
                return Level.ERROR;
            }
            case ALERT: {
                return Level.ERROR;
            }
            case EMERGENCY: {
                return Level.FATAL;
            }
        }
        return Level.WARN;
    }

    @Override
    public void down(SyslogIF syslog, String reason) {
        this.logger.log((Priority)this.downLevel, (Object)("Syslog protocol \"" + syslog.getProtocol() + "\" is down: " + reason));
    }

    @Override
    public void up(SyslogIF syslog) {
        this.logger.log((Priority)this.upLevel, (Object)("Syslog protocol \"" + syslog.getProtocol() + "\" is up"));
    }

    @Override
    public void log(SyslogIF syslog, SyslogLevel level, String message, String reason) throws SyslogRuntimeException {
        Level log4jLevel = Log4jSyslogBackLogHandler.getLog4jLevel(level);
        String combinedMessage = this.combine(syslog, level, message, reason);
        this.logger.log((Priority)log4jLevel, (Object)combinedMessage);
    }
}

