/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message;

import com.nesscomputing.syslog4j.SyslogMessageIF;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractSyslogMessage
implements SyslogMessageIF {
    private static final Logger LOG = Logger.getLogger(AbstractSyslogMessage.class);
    public static final String UNDEFINED = "undefined";
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final char DEFAULT_DELIMITER = ' ';
    public static final String DEFAULT_REPLACE_DELIMITER = "_";

    protected char getDelimiter() {
        return ' ';
    }

    protected String getReplaceDelimiter() {
        return DEFAULT_REPLACE_DELIMITER;
    }

    protected String getDateFormat() {
        return DEFAULT_DATE_FORMAT;
    }

    protected String getTimeFormat() {
        return DEFAULT_TIME_FORMAT;
    }

    protected String generateDate() {
        String date = new SimpleDateFormat(this.getDateFormat()).format(new Date());
        return date;
    }

    protected String generateTime() {
        String time = new SimpleDateFormat(this.getTimeFormat()).format(new Date());
        return time;
    }

    protected String[] generateDateAndTime(Date date) {
        String[] dateAndTime = new String[]{new SimpleDateFormat(this.getDateFormat()).format(date), new SimpleDateFormat(this.getTimeFormat()).format(date)};
        return dateAndTime;
    }

    protected String generateLocalHostName() {
        String localHostName = UNDEFINED;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            LOG.warn((Object)"While finding host name: ", (Throwable)uhe);
        }
        return localHostName;
    }

    protected String replaceDelimiter(String fieldName, String fieldValue, char delimiter, String replaceDelimiter) {
        if (replaceDelimiter == null || replaceDelimiter.length() < 1 || fieldValue == null || fieldValue.length() < 1) {
            return fieldValue;
        }
        String newFieldValue = fieldValue.replaceAll("\\" + delimiter, replaceDelimiter);
        return newFieldValue;
    }

    @Override
    public abstract String createMessage();
}

