/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.modifier;

import com.nesscomputing.syslog4j.SyslogMessageModifierConfigIF;
import com.nesscomputing.syslog4j.SyslogMessageModifierIF;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSyslogMessageModifier
implements SyslogMessageModifierIF {
    protected SyslogMessageModifierConfigIF messageModifierConfig = null;

    public AbstractSyslogMessageModifier(SyslogMessageModifierConfigIF messageModifierConfig) {
        this.messageModifierConfig = messageModifierConfig;
    }

    public String[] parseInlineModifier(String message) {
        return AbstractSyslogMessageModifier.parseInlineModifier(message, this.messageModifierConfig.getPrefix(), this.messageModifierConfig.getSuffix());
    }

    public static String[] parseInlineModifier(String message, String prefix, String suffix) {
        String[] messageAndModifier = null;
        if (StringUtils.isBlank((CharSequence)message)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = " ";
        }
        if (StringUtils.isBlank((CharSequence)suffix)) {
            int pi = message.lastIndexOf(prefix);
            if (pi > -1) {
                messageAndModifier = new String[]{message.substring(0, pi), message.substring(pi + prefix.length())};
            }
        } else {
            int pi;
            int si = message.lastIndexOf(suffix);
            if (si > -1 && (pi = message.lastIndexOf(prefix, si)) > -1) {
                messageAndModifier = new String[]{message.substring(0, pi), message.substring(pi + prefix.length(), si)};
            }
        }
        return messageAndModifier;
    }

    protected abstract boolean verify(String var1, String var2);

    @Override
    public boolean verify(String message) {
        String[] messageAndModifier = this.parseInlineModifier(message);
        if (messageAndModifier == null || messageAndModifier.length != 2) {
            return false;
        }
        return this.verify(messageAndModifier[0], messageAndModifier[1]);
    }
}

