/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.modifier.sequential;

import com.nesscomputing.syslog4j.impl.message.modifier.AbstractSyslogMessageModifierConfig;

public class SequentialSyslogMessageModifierConfig
extends AbstractSyslogMessageModifierConfig {
    protected long firstNumber = 0L;
    protected long lastNumber = 9999L;
    protected char padChar = (char)48;
    protected boolean usePadding = true;

    public static final SequentialSyslogMessageModifierConfig createDefault() {
        SequentialSyslogMessageModifierConfig modifierConfig = new SequentialSyslogMessageModifierConfig();
        return modifierConfig;
    }

    public SequentialSyslogMessageModifierConfig() {
        this.setPrefix(" #");
        this.setSuffix("");
    }

    public long getLastNumberDigits() {
        return Long.toString(this.lastNumber).length();
    }

    public long getFirstNumber() {
        return this.firstNumber;
    }

    public void setFirstNumber(long firstNumber) {
        if (firstNumber < this.lastNumber) {
            this.firstNumber = firstNumber;
        }
    }

    public long getLastNumber() {
        return this.lastNumber;
    }

    public void setLastNumber(long lastNumber) {
        if (lastNumber > this.firstNumber) {
            this.lastNumber = lastNumber;
        }
    }

    public boolean isUsePadding() {
        return this.usePadding;
    }

    public void setUsePadding(boolean usePadding) {
        this.usePadding = usePadding;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public void setPadChar(char padChar) {
        this.padChar = padChar;
    }
}

