/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.pci;

import com.nesscomputing.syslog4j.impl.message.AbstractSyslogMessage;
import com.nesscomputing.syslog4j.impl.message.pci.PCISyslogMessageIF;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PCISyslogMessage
extends AbstractSyslogMessage
implements PCISyslogMessageIF {
    public static final String USER_ID = "userId";
    public static final String EVENT_TYPE = "eventType";
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String STATUS = "status";
    public static final String ORIGINATION = "origination";
    public static final String AFFECTED_RESOURCE = "affectedResource";
    protected String userId = "undefined";
    protected String eventType = "undefined";
    protected String date = null;
    protected String time = null;
    protected String status = "undefined";
    protected String origination = null;
    protected String affectedResource = "undefined";

    public PCISyslogMessage() {
    }

    public PCISyslogMessage(PCISyslogMessageIF message) {
        this.init(message);
    }

    public PCISyslogMessage(Map<String, Object> fields) {
        this.init(fields);
    }

    protected void init(PCISyslogMessageIF message) {
        this.userId = message.getUserId();
        this.eventType = message.getEventType();
        this.date = message.getDate();
        this.time = message.getTime();
        this.status = message.getStatus();
        this.origination = message.getOrigination();
        this.affectedResource = message.getAffectedResource();
    }

    protected void init(Map<String, Object> fields) {
        if (fields.containsKey(USER_ID)) {
            this.userId = (String)fields.get(USER_ID);
        }
        if (fields.containsKey(EVENT_TYPE)) {
            this.eventType = (String)fields.get(EVENT_TYPE);
        }
        if (fields.containsKey(DATE) && fields.get(DATE) instanceof String) {
            this.date = (String)fields.get(DATE);
        }
        if (fields.containsKey(DATE) && fields.get(DATE) instanceof Date) {
            this.setDate((Date)fields.get(DATE));
        }
        if (fields.containsKey(TIME)) {
            this.time = (String)fields.get(TIME);
        }
        if (fields.containsKey(STATUS)) {
            this.status = (String)fields.get(STATUS);
        }
        if (fields.containsKey(ORIGINATION)) {
            this.origination = (String)fields.get(ORIGINATION);
        }
        if (fields.containsKey(AFFECTED_RESOURCE)) {
            this.affectedResource = (String)fields.get(AFFECTED_RESOURCE);
        }
    }

    public PCISyslogMessage(String userId, String eventType, String status, String affectedResource) {
        this.userId = userId;
        this.eventType = eventType;
        this.status = status;
        this.affectedResource = affectedResource;
    }

    public PCISyslogMessage(String userId, String eventType, String status, String origination, String affectedResource) {
        this.userId = userId;
        this.eventType = eventType;
        this.status = status;
        this.origination = origination;
        this.affectedResource = affectedResource;
    }

    public PCISyslogMessage(String userId, String eventType, String date, String time, String status, String affectedResource) {
        this.userId = userId;
        this.eventType = eventType;
        this.date = date;
        this.time = time;
        this.status = status;
        this.affectedResource = affectedResource;
    }

    public PCISyslogMessage(String userId, String eventType, String date, String time, String status, String origination, String affectedResource) {
        this.userId = userId;
        this.eventType = eventType;
        this.date = date;
        this.time = time;
        this.status = status;
        this.origination = origination;
        this.affectedResource = affectedResource;
    }

    public PCISyslogMessage(String userId, String eventType, Date date, String status, String affectedResource) {
        this.userId = userId;
        this.eventType = eventType;
        String[] dateAndTime = this.generateDateAndTime(date);
        this.date = dateAndTime[0];
        this.time = dateAndTime[1];
        this.status = status;
        this.affectedResource = affectedResource;
    }

    public PCISyslogMessage(String userId, String eventType, Date date, String status, String origination, String affectedResource) {
        this.userId = userId;
        this.eventType = eventType;
        String[] dateAndTime = this.generateDateAndTime(date);
        this.date = dateAndTime[0];
        this.time = dateAndTime[1];
        this.status = status;
        this.origination = origination;
        this.affectedResource = affectedResource;
    }

    @Override
    public String getUserId() {
        if (StringUtils.isBlank((CharSequence)this.userId)) {
            return "undefined";
        }
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getEventType() {
        if (StringUtils.isBlank((CharSequence)this.eventType)) {
            return "undefined";
        }
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public String getDate() {
        if (StringUtils.isBlank((CharSequence)this.date)) {
            String dateNow = this.generateDate();
            return dateNow;
        }
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(Date date) {
        String[] d = this.generateDateAndTime(date);
        this.date = d[0];
        this.time = d[1];
    }

    @Override
    public String getTime() {
        if (StringUtils.isBlank((CharSequence)this.time)) {
            String timeNow = this.generateTime();
            return timeNow;
        }
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    @Override
    public String getStatus() {
        if (StringUtils.isBlank((CharSequence)this.status)) {
            return "undefined";
        }
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getOrigination() {
        if (StringUtils.isBlank((CharSequence)this.origination)) {
            String originationHere = this.generateLocalHostName();
            return originationHere;
        }
        return this.origination;
    }

    public void setOrigination(String origination) {
        this.origination = origination;
    }

    @Override
    public String getAffectedResource() {
        if (StringUtils.isBlank((CharSequence)this.affectedResource)) {
            return "undefined";
        }
        return this.affectedResource;
    }

    public void setAffectedResource(String affectedResource) {
        this.affectedResource = affectedResource;
    }

    @Override
    public String getProcId() {
        return null;
    }

    @Override
    public String createMessage() {
        StringBuffer buffer = new StringBuffer();
        char delimiter = this.getDelimiter();
        String replaceDelimiter = this.getReplaceDelimiter();
        buffer.append(this.replaceDelimiter(USER_ID, this.getUserId(), delimiter, replaceDelimiter));
        buffer.append(delimiter);
        buffer.append(this.replaceDelimiter(EVENT_TYPE, this.getEventType(), delimiter, replaceDelimiter));
        buffer.append(delimiter);
        buffer.append(this.replaceDelimiter(DATE, this.getDate(), delimiter, replaceDelimiter));
        buffer.append(delimiter);
        buffer.append(this.replaceDelimiter(TIME, this.getTime(), delimiter, replaceDelimiter));
        buffer.append(delimiter);
        buffer.append(this.replaceDelimiter(STATUS, this.getStatus(), delimiter, replaceDelimiter));
        buffer.append(delimiter);
        buffer.append(this.replaceDelimiter(ORIGINATION, this.getOrigination(), delimiter, replaceDelimiter));
        buffer.append(delimiter);
        buffer.append(this.replaceDelimiter(AFFECTED_RESOURCE, this.getAffectedResource(), delimiter, replaceDelimiter));
        return buffer.toString();
    }
}

