/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.processor;

import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogMessageProcessorIF;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractSyslogMessageProcessor
implements SyslogMessageProcessorIF {
    protected String localName = SyslogUtility.getLocalName();

    @Override
    public byte[] createPacketData(byte[] header, byte[] message, int start, int length) {
        return this.createPacketData(header, message, start, length, null, null);
    }

    @Override
    public byte[] createPacketData(byte[] header, byte[] message, int start, int length, byte[] splitBeginText, byte[] splitEndText) {
        if (header == null || message == null || start < 0 || length < 0) {
            return null;
        }
        int dataLength = header.length + length;
        if (splitBeginText != null) {
            dataLength += splitBeginText.length;
        }
        if (splitEndText != null) {
            dataLength += splitEndText.length;
        }
        byte[] data = new byte[dataLength];
        System.arraycopy(header, 0, data, 0, header.length);
        int pos = header.length;
        if (splitBeginText != null) {
            System.arraycopy(splitBeginText, 0, data, pos, splitBeginText.length);
            pos += splitBeginText.length;
        }
        System.arraycopy(message, start, data, pos, length);
        pos += length;
        if (splitEndText != null) {
            System.arraycopy(splitEndText, 0, data, pos, splitEndText.length);
        }
        return data;
    }

    protected void appendPriority(StringBuffer buffer, SyslogFacility facility, SyslogLevel level) {
        int priority = (facility == null ? 0 : facility.getValue()) | (level == null ? 0 : level.getValue());
        buffer.append("<");
        buffer.append(priority);
        buffer.append(">");
    }

    protected void appendLocalTimestamp(StringBuffer buffer) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss ", Locale.ENGLISH);
        String datePrefix = dateFormat.format(new Date());
        int pos = buffer.length() + 4;
        buffer.append(datePrefix);
        if (buffer.charAt(pos) == '0') {
            buffer.setCharAt(pos, ' ');
        }
    }

    protected void appendLocalName(StringBuffer buffer, String localName) {
        if (localName != null) {
            buffer.append(localName);
        } else {
            buffer.append(this.localName);
        }
        buffer.append(' ');
    }

    @Override
    public String createSyslogHeader(SyslogFacility facility, SyslogLevel level, String localName, String localProcessId, boolean sendLocalTimestamp, boolean sendLocalName) {
        StringBuffer buffer = new StringBuffer();
        this.appendPriority(buffer, facility, level);
        if (sendLocalTimestamp) {
            this.appendLocalTimestamp(buffer);
        }
        if (sendLocalName) {
            this.appendLocalName(buffer, localName);
        }
        return buffer.toString();
    }
}

