/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.processor.structured;

import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.impl.message.processor.AbstractSyslogMessageProcessor;
import com.nesscomputing.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class StructuredSyslogMessageProcessor
extends AbstractSyslogMessageProcessor {
    public static final String VERSION = "1";
    private static final StructuredSyslogMessageProcessor INSTANCE;
    private static StructuredSyslogMessageProcessor defaultInstance;
    private String applicationName = "unknown";
    private String processId = "-";
    private DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();

    public static void setDefault(StructuredSyslogMessageProcessor messageProcessor) {
        if (messageProcessor != null) {
            defaultInstance = messageProcessor;
        }
    }

    public static StructuredSyslogMessageProcessor getDefault() {
        return defaultInstance;
    }

    public StructuredSyslogMessageProcessor() {
    }

    public StructuredSyslogMessageProcessor(String applicationName) {
        this.applicationName = applicationName;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Override
    public String createSyslogHeader(SyslogFacility facility, SyslogLevel level, String localName, String localProcessId, boolean sendLocalTimestamp, boolean sendLocalName) {
        StringBuffer buffer = new StringBuffer();
        this.appendPriority(buffer, facility, level);
        buffer.append(VERSION);
        buffer.append(' ');
        this.getDateTimeFormatter().printTo(buffer, System.currentTimeMillis());
        buffer.append(' ');
        this.appendLocalName(buffer, localName);
        buffer.append(StructuredSyslogMessage.nilProtect(this.applicationName)).append(' ');
        buffer.append(StructuredSyslogMessage.nilProtect((String)ObjectUtils.firstNonNull((Object[])new String[]{localProcessId, this.processId}))).append(' ');
        return buffer.toString();
    }

    static {
        defaultInstance = INSTANCE = new StructuredSyslogMessageProcessor();
    }
}

