/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.net;

import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslog;
import com.nesscomputing.syslog4j.impl.net.AbstractNetSyslogConfigIF;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import java.net.InetAddress;

public abstract class AbstractNetSyslog
extends AbstractSyslog {
    protected static final Object cachedHostAddressSyncObject = new Object();
    private volatile InetAddress cachedHostAddress = null;
    protected AbstractNetSyslogConfigIF netSyslogConfig = null;

    @Override
    protected void initialize() throws SyslogRuntimeException {
        try {
            this.netSyslogConfig = (AbstractNetSyslogConfigIF)this.syslogConfig;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must implement interface AbstractNetSyslogConfigIF", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getHostAddress() {
        InetAddress hostAddress = null;
        if (this.netSyslogConfig.isCacheHostAddress()) {
            if (this.cachedHostAddress == null) {
                Object object = cachedHostAddressSyncObject;
                synchronized (object) {
                    if (this.cachedHostAddress == null) {
                        this.cachedHostAddress = SyslogUtility.getInetAddress(this.syslogConfig.getHost());
                    }
                }
            }
            hostAddress = this.cachedHostAddress;
        } else {
            hostAddress = SyslogUtility.getInetAddress(this.syslogConfig.getHost());
        }
        return hostAddress;
    }
}

