/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.net.tcp;

import com.google.common.base.Charsets;
import com.nesscomputing.syslog4j.SyslogConstants;
import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.impl.AbstractSyslogWriter;
import com.nesscomputing.syslog4j.impl.net.AbstractNetSyslogConfig;
import com.nesscomputing.syslog4j.impl.net.tcp.TCPNetSyslog;
import com.nesscomputing.syslog4j.impl.net.tcp.TCPNetSyslogConfigIF;
import com.nesscomputing.syslog4j.impl.net.tcp.TCPNetSyslogWriter;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class TCPNetSyslogConfig
extends AbstractNetSyslogConfig
implements TCPNetSyslogConfigIF {
    static final byte[] SYSTEM_DELIMITER_SEQUENCE;
    protected byte[] delimiterSequence = SYSTEM_DELIMITER_SEQUENCE;
    protected boolean persistentConnection = true;
    protected boolean soLinger = true;
    protected int soLingerSeconds = 1;
    protected boolean keepAlive = true;
    protected boolean reuseAddress = true;
    protected boolean setBufferSize = true;
    protected int freshConnectionInterval = -1;

    public TCPNetSyslogConfig() {
        this.initialize();
    }

    protected void initialize() {
    }

    public TCPNetSyslogConfig(SyslogFacility facility, String host, int port) {
        super(facility, host, port);
        this.initialize();
    }

    public TCPNetSyslogConfig(SyslogFacility facility, String host) {
        super(facility, host);
        this.initialize();
    }

    public TCPNetSyslogConfig(SyslogFacility facility) {
        super(facility);
        this.initialize();
    }

    public TCPNetSyslogConfig(String host, int port) {
        super(host, port);
        this.initialize();
    }

    public TCPNetSyslogConfig(String host) {
        super(host);
        this.initialize();
    }

    @Override
    public Class<? extends SyslogIF> getSyslogClass() {
        return TCPNetSyslog.class;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getDelimiterSequence() {
        return this.delimiterSequence;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setDelimiterSequence(byte[] delimiterSequence) {
        this.delimiterSequence = delimiterSequence;
    }

    public void setDelimiterSequence(String delimiterSequence) {
        this.delimiterSequence = SyslogUtility.getBytes(this, delimiterSequence);
    }

    @Override
    public boolean isPersistentConnection() {
        return this.persistentConnection;
    }

    @Override
    public void setPersistentConnection(boolean persistentConnection) {
        this.persistentConnection = persistentConnection;
    }

    @Override
    public boolean isSoLinger() {
        return this.soLinger;
    }

    @Override
    public void setSoLinger(boolean soLinger) {
        this.soLinger = soLinger;
    }

    @Override
    public int getSoLingerSeconds() {
        return this.soLingerSeconds;
    }

    @Override
    public void setSoLingerSeconds(int soLingerSeconds) {
        this.soLingerSeconds = soLingerSeconds;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Override
    public boolean isSetBufferSize() {
        return this.setBufferSize;
    }

    @Override
    public void setSetBufferSize(boolean setBufferSize) {
        this.setBufferSize = setBufferSize;
    }

    @Override
    public int getFreshConnectionInterval() {
        return this.freshConnectionInterval;
    }

    @Override
    public void setFreshConnectionInterval(int freshConnectionInterval) {
        this.freshConnectionInterval = freshConnectionInterval;
    }

    @Override
    public Class<? extends AbstractSyslogWriter> getSyslogWriterClass() {
        return TCPNetSyslogWriter.class;
    }

    static {
        String delimiterSequence = System.getProperty("line.separator");
        byte[] systemDelimiterSequence = delimiterSequence.getBytes(Charsets.UTF_8);
        if (systemDelimiterSequence == null || systemDelimiterSequence.length < 1) {
            systemDelimiterSequence = SyslogConstants.TCP_DELIMITER_SEQUENCE_DEFAULT;
        }
        SYSTEM_DELIMITER_SEQUENCE = systemDelimiterSequence;
    }
}

