/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.net.tcp.pool;

import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslogWriter;
import com.nesscomputing.syslog4j.impl.net.tcp.TCPNetSyslog;
import com.nesscomputing.syslog4j.impl.pool.AbstractSyslogPoolFactory;
import com.nesscomputing.syslog4j.impl.pool.generic.GenericSyslogPoolFactory;
import org.apache.log4j.Logger;

public class PooledTCPNetSyslog
extends TCPNetSyslog {
    private final Logger LOG = Logger.getLogger(PooledTCPNetSyslog.class);
    protected AbstractSyslogPoolFactory poolFactory = null;

    @Override
    public void initialize() throws SyslogRuntimeException {
        super.initialize();
        this.poolFactory = this.createSyslogPoolFactory();
        this.poolFactory.initialize(this);
    }

    protected AbstractSyslogPoolFactory createSyslogPoolFactory() {
        GenericSyslogPoolFactory syslogPoolFactory = new GenericSyslogPoolFactory();
        return syslogPoolFactory;
    }

    @Override
    public AbstractSyslogWriter getWriter() {
        try {
            AbstractSyslogWriter syslogWriter = this.poolFactory.borrowSyslogWriter();
            return syslogWriter;
        }
        catch (Exception e) {
            throw new SyslogRuntimeException(e);
        }
    }

    @Override
    public void returnWriter(AbstractSyslogWriter syslogWriter) {
        try {
            this.poolFactory.returnSyslogWriter(syslogWriter);
        }
        catch (Exception e) {
            throw new SyslogRuntimeException(e);
        }
    }

    @Override
    public void flush() throws SyslogRuntimeException {
        try {
            this.poolFactory.clear();
        }
        catch (Exception e) {
            this.LOG.trace((Object)"While flushing", (Throwable)e);
        }
    }

    @Override
    public void shutdown() throws SyslogRuntimeException {
        try {
            this.poolFactory.close();
        }
        catch (Exception e) {
            this.LOG.trace((Object)"While shutdown", (Throwable)e);
        }
    }
}

