/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.server;

import com.google.common.collect.Maps;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.server.SyslogServerConfigIF;
import com.nesscomputing.syslog4j.server.SyslogServerIF;
import com.nesscomputing.syslog4j.server.SyslogServerMain;
import com.nesscomputing.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfig;
import com.nesscomputing.syslog4j.server.impl.net.udp.UDPNetSyslogServerConfig;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SyslogServer {
    private static boolean SUPPRESS_RUNTIME_EXCEPTIONS = false;
    protected static final Map<String, SyslogServerIF> instances = Maps.newHashMap();

    private SyslogServer() {
    }

    public static void setSuppressRuntimeExceptions(boolean suppress) {
        SUPPRESS_RUNTIME_EXCEPTIONS = suppress;
    }

    public static boolean getSuppressRuntimeExceptions() {
        return SUPPRESS_RUNTIME_EXCEPTIONS;
    }

    private static void throwRuntimeException(String message) throws SyslogRuntimeException {
        if (SUPPRESS_RUNTIME_EXCEPTIONS) {
            return;
        }
        throw new SyslogRuntimeException(message.toString(), new Object[0]);
    }

    public static final SyslogServerIF getInstance(String protocol) throws SyslogRuntimeException {
        String syslogProtocol = protocol.toLowerCase();
        if (instances.containsKey(syslogProtocol)) {
            return instances.get(syslogProtocol);
        }
        SyslogServer.throwRuntimeException("SyslogServer instance \"" + syslogProtocol + "\" not defined; use \"tcp\" or \"udp\" or call SyslogServer.createInstance(protocol,config) first");
        return null;
    }

    public static final SyslogServerIF getThreadedInstance(String protocol) throws SyslogRuntimeException {
        SyslogServerIF server = SyslogServer.getInstance(protocol);
        if (server.getThread() == null) {
            Thread thread = new Thread(server);
            thread.setName("SyslogServer: " + protocol);
            thread.setDaemon(server.getConfig().isUseDaemonThread());
            if (server.getConfig().getThreadPriority() > -1) {
                thread.setPriority(server.getConfig().getThreadPriority());
            }
            server.setThread(thread);
            thread.start();
        }
        return server;
    }

    public static final boolean exists(String protocol) {
        if (StringUtils.isBlank((CharSequence)protocol)) {
            return false;
        }
        return instances.containsKey(protocol.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SyslogServerIF createInstance(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
        if (StringUtils.isBlank((CharSequence)protocol)) {
            SyslogServer.throwRuntimeException("Instance protocol cannot be null or empty");
            return null;
        }
        if (config == null) {
            SyslogServer.throwRuntimeException("SyslogServerConfig cannot be null");
            return null;
        }
        String syslogProtocol = protocol.toLowerCase();
        SyslogServerIF syslogServer = null;
        Map<String, SyslogServerIF> map = instances;
        synchronized (map) {
            if (instances.containsKey(syslogProtocol)) {
                SyslogServer.throwRuntimeException("SyslogServer instance \"" + syslogProtocol + "\" already defined.");
                return null;
            }
            try {
                Class<? extends SyslogServerIF> syslogClass = config.getSyslogServerClass();
                syslogServer = syslogClass.newInstance();
            }
            catch (ClassCastException cse) {
                throw new SyslogRuntimeException(cse);
            }
            catch (IllegalAccessException iae) {
                throw new SyslogRuntimeException(iae);
            }
            catch (InstantiationException ie) {
                throw new SyslogRuntimeException(ie);
            }
            syslogServer.initialize(syslogProtocol, config);
            instances.put(syslogProtocol, syslogServer);
        }
        return syslogServer;
    }

    public static final SyslogServerIF createThreadedInstance(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
        SyslogServer.createInstance(protocol, config);
        SyslogServerIF server = SyslogServer.getThreadedInstance(protocol);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(String protocol) {
        if (StringUtils.isBlank((CharSequence)protocol)) {
            return;
        }
        String _protocol = protocol.toLowerCase();
        if (instances.containsKey(_protocol)) {
            SyslogUtility.sleep(500L);
            SyslogServerIF syslogServer = instances.get(_protocol);
            try {
                syslogServer.shutdown();
            }
            finally {
                instances.remove(_protocol);
            }
        } else {
            SyslogServer.throwRuntimeException("Cannot destroy server protocol \"" + protocol + "\" instance; call shutdown instead");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(SyslogServerIF syslogServer) {
        if (syslogServer == null) {
            return;
        }
        String protocol = syslogServer.getProtocol().toLowerCase();
        if (instances.containsKey(protocol)) {
            SyslogUtility.sleep(500L);
            try {
                syslogServer.shutdown();
            }
            finally {
                instances.remove(protocol);
            }
        } else {
            SyslogServer.throwRuntimeException("Cannot destroy server protocol \"" + protocol + "\" instance; call shutdown instead");
        }
    }

    public static synchronized void initialize() {
        SyslogServer.createInstance("udp", new UDPNetSyslogServerConfig());
        SyslogServer.createInstance("tcp", new TCPNetSyslogServerConfig());
    }

    public static final synchronized void shutdown() throws SyslogRuntimeException {
        Set<String> protocols = instances.keySet();
        for (String protocol : protocols) {
            SyslogServerIF syslogServer = instances.get(protocol);
            syslogServer.shutdown();
        }
        instances.clear();
    }

    public static void main(String[] args) throws Exception {
        SyslogServerMain.main(args);
    }

    static {
        SyslogServer.initialize();
    }
}

