/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.server.impl;

import com.google.common.collect.Maps;
import com.nesscomputing.syslog4j.SyslogCharSetIF;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.server.SyslogServerConfigIF;
import com.nesscomputing.syslog4j.server.SyslogServerEventHandlerIF;
import com.nesscomputing.syslog4j.server.SyslogServerEventIF;
import com.nesscomputing.syslog4j.server.SyslogServerIF;
import com.nesscomputing.syslog4j.server.SyslogServerSessionEventHandlerIF;
import com.nesscomputing.syslog4j.server.SyslogServerSessionlessEventHandlerIF;
import com.nesscomputing.syslog4j.server.impl.AbstractSyslogServerConfig;
import com.nesscomputing.syslog4j.server.impl.event.SyslogServerEvent;
import com.nesscomputing.syslog4j.server.impl.event.structured.StructuredSyslogServerEvent;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public abstract class AbstractSyslogServer
implements SyslogServerIF {
    private static final Logger LOG = Logger.getLogger(AbstractSyslogServer.class);
    protected String syslogProtocol = null;
    protected AbstractSyslogServerConfig syslogServerConfig = null;
    private Thread thread = null;
    protected boolean shutdown = false;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    @Override
    public void initialize(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
        this.syslogProtocol = protocol;
        try {
            this.syslogServerConfig = (AbstractSyslogServerConfig)config;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException(cce);
        }
        this.initialize();
    }

    @Override
    public String getProtocol() {
        return this.syslogProtocol;
    }

    @Override
    public SyslogServerConfigIF getConfig() {
        return this.syslogServerConfig;
    }

    protected abstract void initialize() throws SyslogRuntimeException;

    @Override
    public void shutdown() throws SyslogRuntimeException {
        this.shutdown = true;
    }

    @Override
    public synchronized Thread getThread() {
        return this.thread;
    }

    @Override
    public synchronized void setThread(Thread thread) {
        this.thread = thread;
    }

    protected synchronized void interruptThread() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    protected static boolean isStructuredMessage(SyslogCharSetIF syslogCharSet, byte[] receiveData) {
        String receiveDataString = SyslogUtility.newString(syslogCharSet, receiveData);
        boolean isStructuredMessage = AbstractSyslogServer.isStructuredMessage(syslogCharSet, receiveDataString);
        return isStructuredMessage;
    }

    protected static boolean isStructuredMessage(SyslogCharSetIF syslogCharSet, String receiveData) {
        int idx = receiveData.indexOf(62);
        return idx != -1 && receiveData.length() > idx + 1 && Character.isDigit(receiveData.charAt(idx + 1));
    }

    protected static SyslogServerEventIF createEvent(SyslogServerConfigIF serverConfig, byte[] lineBytes, int lineBytesLength, InetAddress inetAddr) {
        SyslogServerEvent event = null;
        if (serverConfig.isUseStructuredData() && AbstractSyslogServer.isStructuredMessage((SyslogCharSetIF)serverConfig, lineBytes)) {
            event = new StructuredSyslogServerEvent(lineBytes, lineBytesLength, inetAddr);
            if (serverConfig.getDateTimeFormatter() != null) {
                ((StructuredSyslogServerEvent)event).setDateTimeFormatter(serverConfig.getDateTimeFormatter());
            }
        } else {
            event = new SyslogServerEvent(lineBytes, lineBytesLength, inetAddr);
        }
        return event;
    }

    protected static SyslogServerEventIF createEvent(SyslogServerConfigIF serverConfig, String line, InetAddress inetAddr) {
        SyslogServerEvent event = null;
        event = serverConfig.isUseStructuredData() && AbstractSyslogServer.isStructuredMessage((SyslogCharSetIF)serverConfig, line) ? new StructuredSyslogServerEvent(line, inetAddr) : new SyslogServerEvent(line, inetAddr);
        return event;
    }

    public void handleInitialize(SyslogServerIF syslogServer) {
        List<? extends SyslogServerEventHandlerIF> eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = eventHandlers.get(i);
            try {
                eventHandler.initialize(syslogServer);
                continue;
            }
            catch (Exception exception) {
                LOG.warn((Object)"While initializing", (Throwable)exception);
            }
        }
        this.started.set(true);
    }

    public void handleDestroy(SyslogServerIF syslogServer) {
        List<? extends SyslogServerEventHandlerIF> eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = eventHandlers.get(i);
            try {
                eventHandler.destroy(syslogServer);
                continue;
            }
            catch (Exception exception) {
                LOG.warn((Object)"While destroying", (Throwable)exception);
            }
        }
        this.stopped.set(true);
    }

    public static void handleSessionOpen(Sessions sessions, SyslogServerIF syslogServer, Socket socket) {
        List<? extends SyslogServerEventHandlerIF> eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = eventHandlers.get(i);
            if (!(eventHandler instanceof SyslogServerSessionEventHandlerIF)) continue;
            try {
                Object session = ((SyslogServerSessionEventHandlerIF)eventHandler).sessionOpened(syslogServer, socket.getRemoteSocketAddress());
                if (session == null) continue;
                sessions.addSession(socket, eventHandler, session);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).exception(null, syslogServer, socket.getRemoteSocketAddress(), exception);
                    continue;
                }
                catch (Exception e) {
                    LOG.trace((Object)"While handling exception", (Throwable)exception);
                }
            }
        }
    }

    public static void handleSessionClosed(Sessions sessions, SyslogServerIF syslogServer, Socket socket, boolean timeout) {
        List<? extends SyslogServerEventHandlerIF> eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = eventHandlers.get(i);
            if (!(eventHandler instanceof SyslogServerSessionEventHandlerIF)) continue;
            Object session = sessions.getSession(socket, eventHandler);
            try {
                ((SyslogServerSessionEventHandlerIF)eventHandler).sessionClosed(session, syslogServer, socket.getRemoteSocketAddress(), timeout);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).exception(session, syslogServer, socket.getRemoteSocketAddress(), exception);
                    continue;
                }
                catch (Exception e) {
                    LOG.trace((Object)"While handling exception", (Throwable)exception);
                }
            }
        }
    }

    public static void handleEvent(Sessions sessions, SyslogServerIF syslogServer, DatagramPacket packet, SyslogServerEventIF event) {
        AbstractSyslogServer.handleEvent(sessions, syslogServer, null, packet.getSocketAddress(), event);
    }

    public static void handleEvent(Sessions sessions, SyslogServerIF syslogServer, Socket socket, SyslogServerEventIF event) {
        AbstractSyslogServer.handleEvent(sessions, syslogServer, socket, socket.getRemoteSocketAddress(), event);
    }

    protected static void handleEvent(Sessions sessions, SyslogServerIF syslogServer, Socket socket, SocketAddress socketAddress, SyslogServerEventIF event) {
        List<? extends SyslogServerEventHandlerIF> eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            Object session;
            SyslogServerEventHandlerIF eventHandler = eventHandlers.get(i);
            Object object = session = sessions != null && socket != null ? sessions.getSession(socket, eventHandler) : null;
            if (eventHandler instanceof SyslogServerSessionEventHandlerIF) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).event(session, syslogServer, socketAddress, event);
                }
                catch (Exception exception) {
                    try {
                        ((SyslogServerSessionEventHandlerIF)eventHandler).exception(session, syslogServer, socketAddress, exception);
                    }
                    catch (Exception e) {
                        LOG.trace((Object)"While handling exception", (Throwable)exception);
                    }
                }
                continue;
            }
            if (!(eventHandler instanceof SyslogServerSessionlessEventHandlerIF)) continue;
            try {
                ((SyslogServerSessionlessEventHandlerIF)eventHandler).event(syslogServer, socketAddress, event);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionlessEventHandlerIF)eventHandler).exception(syslogServer, socketAddress, exception);
                    continue;
                }
                catch (Exception e) {
                    LOG.trace((Object)"While handling exception", (Throwable)exception);
                }
            }
        }
    }

    public static void handleException(Object session, SyslogServerIF syslogServer, SocketAddress socketAddress, Exception exception) {
        List<? extends SyslogServerEventHandlerIF> eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = eventHandlers.get(i);
            if (eventHandler instanceof SyslogServerSessionEventHandlerIF) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).exception(session, syslogServer, socketAddress, exception);
                }
                catch (Exception e) {
                    LOG.trace((Object)"While handling exception", (Throwable)exception);
                }
                continue;
            }
            if (!(eventHandler instanceof SyslogServerSessionlessEventHandlerIF)) continue;
            try {
                ((SyslogServerSessionlessEventHandlerIF)eventHandler).exception(syslogServer, socketAddress, exception);
                continue;
            }
            catch (Exception e) {
                LOG.trace((Object)"While handling exception", (Throwable)exception);
            }
        }
    }

    public static class Sessions
    extends HashMap<Socket, Map<SyslogServerEventHandlerIF, Object>> {
        private static final long serialVersionUID = 1L;
        public static final Object syncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSocket(Socket socket) {
            Object object = syncObject;
            synchronized (object) {
                this.put(socket, new HashMap());
            }
        }

        public Iterator<Socket> getSockets() {
            if (this.size() > 0) {
                return this.keySet().iterator();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSession(Socket socket, SyslogServerEventHandlerIF eventHandler, Object session) {
            Object object = syncObject;
            synchronized (object) {
                HashMap handlerMap = this.getHandlerMap(socket);
                if (handlerMap == null) {
                    handlerMap = Maps.newHashMap();
                }
                handlerMap.put(eventHandler, session);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSocket(Socket socket) {
            Object object = syncObject;
            synchronized (object) {
                Map<SyslogServerEventHandlerIF, Object> handlerMap = this.getHandlerMap(socket);
                if (handlerMap != null) {
                    handlerMap.clear();
                }
            }
        }

        protected Map<SyslogServerEventHandlerIF, Object> getHandlerMap(Socket socket) {
            Map handlerMap = null;
            if (this.containsKey(socket)) {
                handlerMap = (Map)this.get(socket);
            }
            return handlerMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getSession(Socket socket, SyslogServerEventHandlerIF eventHandler) {
            Object object = syncObject;
            synchronized (object) {
                Map<SyslogServerEventHandlerIF, Object> handlerMap = this.getHandlerMap(socket);
                Object session = handlerMap.get(eventHandler);
                return session;
            }
        }
    }
}

