/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.server.impl.net.udp;

import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.server.SyslogServerEventIF;
import com.nesscomputing.syslog4j.server.SyslogServerIF;
import com.nesscomputing.syslog4j.server.impl.AbstractSyslogServer;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class UDPNetSyslogServer
extends AbstractSyslogServer {
    private static final Logger LOG = Logger.getLogger(UDPNetSyslogServer.class);
    protected DatagramSocket ds = null;

    @Override
    public void initialize() throws SyslogRuntimeException {
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.syslogServerConfig.getShutdownWait() > 0L) {
            SyslogUtility.sleep(this.syslogServerConfig.getShutdownWait());
        }
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    protected DatagramSocket createDatagramSocket() throws SocketException, UnknownHostException {
        DatagramSocket datagramSocket = null;
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort(), inetAddress);
        } else {
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort());
        }
        return datagramSocket;
    }

    @Override
    public void run() {
        try {
            this.ds = this.createDatagramSocket();
            this.shutdown = false;
        }
        catch (SocketException se) {
            LOG.warn((Object)"While creating datagram socket", (Throwable)se);
            return;
        }
        catch (UnknownHostException uhe) {
            LOG.warn((Object)"While creating datagram socket", (Throwable)uhe);
            return;
        }
        byte[] receiveData = new byte[1024];
        this.handleInitialize(this);
        while (!this.shutdown) {
            DatagramPacket dp = null;
            try {
                dp = new DatagramPacket(receiveData, receiveData.length);
                this.ds.receive(dp);
                SyslogServerEventIF event = UDPNetSyslogServer.createEvent(this.getConfig(), receiveData, dp.getLength(), dp.getAddress());
                UDPNetSyslogServer.handleEvent(null, (SyslogServerIF)this, dp, event);
            }
            catch (SocketException se) {
                int i = se.getMessage() == null ? -1 : se.getMessage().toLowerCase().indexOf("socket closed");
                if (i != -1) continue;
                UDPNetSyslogServer.handleException(null, this, dp.getSocketAddress(), se);
            }
            catch (IOException ioe) {
                UDPNetSyslogServer.handleException(null, this, dp.getSocketAddress(), ioe);
            }
        }
        this.handleDestroy(this);
    }

    @Override
    public int getActualPort() {
        return this.ds.getLocalPort();
    }
}

