/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive;

import com.netease.arctic.hive.HMSClient;
import com.netease.arctic.hive.HMSClientImpl;
import com.netease.arctic.table.TableMetaStore;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.iceberg.ClientPoolImpl;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.hive.RuntimeMetaException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcticHiveClientPool
extends ClientPoolImpl<HMSClient, TException> {
    private final TableMetaStore metaStore;
    private final HiveConf hiveConf;
    private static final Logger LOG = LoggerFactory.getLogger(ArcticHiveClientPool.class);
    private static final DynConstructors.Ctor<HiveMetaStoreClient> CLIENT_CTOR = DynConstructors.builder().impl(HiveMetaStoreClient.class, new Class[]{HiveConf.class}).impl(HiveMetaStoreClient.class, new Class[]{Configuration.class}).build();

    public ArcticHiveClientPool(TableMetaStore tableMetaStore, int poolSize) {
        super(poolSize, TTransportException.class, false);
        this.hiveConf = new HiveConf(tableMetaStore.getConfiguration(), ArcticHiveClientPool.class);
        this.hiveConf.addResource(tableMetaStore.getConfiguration());
        this.hiveConf.addResource((URL)tableMetaStore.getHiveSiteLocation().orElse(null));
        this.metaStore = tableMetaStore;
    }

    protected HMSClient newClient() {
        return (HMSClient)this.metaStore.doAs(() -> {
            try {
                try {
                    HiveMetaStoreClient client = (HiveMetaStoreClient)CLIENT_CTOR.newInstance(new Object[]{this.hiveConf});
                    return new HMSClientImpl(client);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof MetaException) {
                        throw (MetaException)e.getCause();
                    }
                    throw e;
                }
            }
            catch (MetaException e) {
                throw new RuntimeMetaException(e, "Failed to connect to Hive Metastore", new Object[0]);
            }
            catch (Throwable t) {
                if (t.getMessage().contains("Another instance of Derby may have already booted")) {
                    throw new RuntimeMetaException(t, "Failed to start an embedded metastore because embedded Derby supports only one client at a time. To fix this, use a metastore that supports multiple clients.", new Object[0]);
                }
                throw new RuntimeMetaException(t, "Failed to connect to Hive Metastore", new Object[0]);
            }
        });
    }

    protected HMSClient reconnect(HMSClient client) {
        try {
            return (HMSClient)this.metaStore.doAs(() -> {
                try {
                    client.close();
                    client.reconnect();
                }
                catch (MetaException e) {
                    throw new RuntimeMetaException(e, "Failed to reconnect to Hive Metastore", new Object[0]);
                }
                return client;
            });
        }
        catch (Exception e) {
            LOG.error("hive metastore client reconnected failed", (Throwable)e);
            throw e;
        }
    }

    protected boolean isConnectionException(Exception e) {
        return super.isConnectionException(e) || e != null && e instanceof MetaException && e.getMessage().contains("Got exception: org.apache.thrift.transport.TTransportException");
    }

    protected void close(HMSClient client) {
        client.close();
    }
}

