/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.netease.arctic.ams.api.properties.CatalogMetaProperties;
import com.netease.arctic.hive.ArcticHiveClientPool;
import com.netease.arctic.hive.HMSClient;
import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.table.TableMetaStore;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.thrift.TException;

public class CachedHiveClientPool
implements HMSClientPool,
Serializable {
    private static Cache<TableMetaStore, ArcticHiveClientPool> clientPoolCache;
    private final TableMetaStore tableMetaStore;
    private final int clientPoolSize;
    private final long evictionInterval;

    public CachedHiveClientPool(TableMetaStore tableMetaStore, Map<String, String> properties) {
        this.tableMetaStore = tableMetaStore;
        this.clientPoolSize = PropertyUtil.propertyAsInt(properties, (String)"clients", (int)2);
        this.evictionInterval = PropertyUtil.propertyAsLong(properties, (String)"client.pool.cache.eviction-interval-ms", (long)CatalogMetaProperties.CLIENT_POOL_CACHE_EVICTION_INTERVAL_MS_DEFAULT);
        this.init();
    }

    private ArcticHiveClientPool clientPool() {
        return (ArcticHiveClientPool)((Object)clientPoolCache.get((Object)this.tableMetaStore, k -> new ArcticHiveClientPool(this.tableMetaStore, this.clientPoolSize)));
    }

    private synchronized void init() {
        if (clientPoolCache == null) {
            clientPoolCache = Caffeine.newBuilder().expireAfterAccess(this.evictionInterval, TimeUnit.MILLISECONDS).removalListener((key, value, cause) -> ((ArcticHiveClientPool)((Object)((Object)value))).close()).build();
        }
    }

    public <R> R run(ClientPool.Action<R, HMSClient, TException> action) throws TException, InterruptedException {
        try {
            return (R)this.tableMetaStore.doAs(() -> this.clientPool().run(action));
        }
        catch (RuntimeException e) {
            throw this.throwTException(e);
        }
    }

    public <R> R run(ClientPool.Action<R, HMSClient, TException> action, boolean retry) throws TException, InterruptedException {
        try {
            return (R)this.tableMetaStore.doAs(() -> this.clientPool().run(action, retry));
        }
        catch (RuntimeException e) {
            throw this.throwTException(e);
        }
    }

    public RuntimeException throwTException(RuntimeException e) throws TException {
        if (e.getCause() instanceof NoSuchObjectException) {
            throw (NoSuchObjectException)e.getCause();
        }
        if (e.getCause() instanceof AlreadyExistsException) {
            throw (AlreadyExistsException)e.getCause();
        }
        if (e.getCause() instanceof InvalidOperationException) {
            throw (InvalidOperationException)e.getCause();
        }
        if (e.getCause() instanceof InvalidObjectException) {
            throw (InvalidObjectException)e.getCause();
        }
        if (e.getCause() instanceof MetaException) {
            throw (MetaException)e.getCause();
        }
        if (e.getCause() instanceof UnknownDBException) {
            throw (UnknownDBException)e.getCause();
        }
        if (e.getCause() instanceof UnknownTableException) {
            throw (UnknownTableException)e.getCause();
        }
        throw e;
    }
}

