/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.io.writer;

import com.netease.arctic.hive.io.writer.OperateToTableRelation;
import com.netease.arctic.hive.table.HiveLocationKind;
import com.netease.arctic.hive.utils.TableTypeUtil;
import com.netease.arctic.table.ArcticTable;
import com.netease.arctic.table.BaseLocationKind;
import com.netease.arctic.table.ChangeLocationKind;
import com.netease.arctic.table.LocationKind;
import com.netease.arctic.table.WriteOperationKind;

public class AdaptHiveOperateToTableRelation
implements OperateToTableRelation {
    public static final AdaptHiveOperateToTableRelation INSTANT = new AdaptHiveOperateToTableRelation();

    @Override
    public LocationKind getLocationKindsFromOperateKind(ArcticTable arcticTable, WriteOperationKind writeOperationKind) {
        if (arcticTable.isKeyedTable()) {
            if (TableTypeUtil.isHive(arcticTable)) {
                switch (writeOperationKind) {
                    case APPEND: {
                        return ChangeLocationKind.INSTANT;
                    }
                    case MINOR_OPTIMIZE: 
                    case MAJOR_OPTIMIZE: {
                        return BaseLocationKind.INSTANT;
                    }
                    case OVERWRITE: 
                    case FULL_OPTIMIZE: {
                        return HiveLocationKind.INSTANT;
                    }
                }
            } else {
                switch (writeOperationKind) {
                    case APPEND: {
                        return ChangeLocationKind.INSTANT;
                    }
                    case MINOR_OPTIMIZE: 
                    case MAJOR_OPTIMIZE: 
                    case OVERWRITE: 
                    case FULL_OPTIMIZE: {
                        return BaseLocationKind.INSTANT;
                    }
                }
            }
        } else if (TableTypeUtil.isHive(arcticTable)) {
            switch (writeOperationKind) {
                case APPEND: 
                case MAJOR_OPTIMIZE: {
                    return BaseLocationKind.INSTANT;
                }
                case OVERWRITE: 
                case FULL_OPTIMIZE: {
                    return HiveLocationKind.INSTANT;
                }
                case MINOR_OPTIMIZE: {
                    throw new IllegalArgumentException("UnKeyed table don't support minor optimize");
                }
            }
        } else {
            return BaseLocationKind.INSTANT;
        }
        return null;
    }
}

