/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.io.writer;

import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.io.ArcticFileIO;
import com.netease.arctic.io.writer.OutputFileFactory;
import com.netease.arctic.io.writer.TaskWriterKey;
import com.netease.arctic.utils.FileUtil;
import com.netease.arctic.utils.IdGenerator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.OutputFile;

public class AdaptHiveOutputFileFactory
implements OutputFileFactory {
    public static final String SEPARATOR = "-";
    public static final int TRANSACTION_INDEX = 2;
    private final String baseLocation;
    private final String hiveSubDirectory;
    private final PartitionSpec partitionSpec;
    private final FileFormat format;
    private final ArcticFileIO io;
    private final EncryptionManager encryptionManager;
    private final int partitionId;
    private final long taskId;
    private final long transactionId;
    private final AtomicLong fileCount = new AtomicLong(0L);

    public AdaptHiveOutputFileFactory(String baseLocation, PartitionSpec partitionSpec, FileFormat format, ArcticFileIO io, EncryptionManager encryptionManager, int partitionId, long taskId, Long transactionId) {
        this(baseLocation, partitionSpec, format, io, encryptionManager, partitionId, taskId, transactionId, null);
    }

    public AdaptHiveOutputFileFactory(String baseLocation, PartitionSpec partitionSpec, FileFormat format, ArcticFileIO io, EncryptionManager encryptionManager, int partitionId, long taskId, Long transactionId, String hiveSubDirectory) {
        this.baseLocation = baseLocation;
        this.partitionSpec = partitionSpec;
        this.format = format;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.partitionId = partitionId;
        this.taskId = taskId;
        this.transactionId = transactionId == null ? IdGenerator.randomId() : transactionId;
        this.hiveSubDirectory = hiveSubDirectory == null ? HiveTableUtil.newHiveSubdirectory(this.transactionId) : hiveSubDirectory;
    }

    private String generateFilename(TaskWriterKey key) {
        return this.format.addExtension(String.format("%d-%s-%d-%05d-%d-%010d", key.getTreeNode().getId(), key.getFileType().shortName(), this.transactionId, this.partitionId, this.taskId, this.fileCount.incrementAndGet()));
    }

    private String fileLocation(StructLike partitionData, String fileName) {
        return String.format("%s/%s", HiveTableUtil.newHiveDataLocation(this.baseLocation, this.partitionSpec, partitionData, this.hiveSubDirectory), fileName);
    }

    public EncryptedOutputFile newOutputFile(TaskWriterKey key) {
        String fileLocation = this.fileLocation(key.getPartitionKey(), this.generateFilename(key));
        OutputFile outputFile = this.io.newOutputFile(fileLocation);
        return this.encryptionManager.encrypt(outputFile);
    }

    public static int parseTransactionId(CharSequence path) {
        String fileName = FileUtil.getFileName((String)path.toString());
        String[] values = fileName.split(SEPARATOR);
        if (values.length <= 2) {
            throw new IllegalArgumentException("path is invalid. " + path);
        }
        return Integer.parseInt(values[2]);
    }
}

