/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.op;

import com.netease.arctic.table.ArcticTable;
import java.util.Collection;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class BaseSchemaUpdate
implements UpdateSchema {
    private final ArcticTable arcticTable;
    private final UpdateSchema updateSchema;

    public BaseSchemaUpdate(ArcticTable arcticTable, UpdateSchema updateSchema) {
        this.arcticTable = arcticTable;
        this.updateSchema = updateSchema;
    }

    public Schema apply() {
        return (Schema)this.updateSchema.apply();
    }

    public void commit() {
        this.updateSchema.commit();
    }

    public UpdateSchema allowIncompatibleChanges() {
        throw new UnsupportedOperationException("hive table not support allowIncompatibleChanges");
    }

    public UpdateSchema addColumn(String name, Type type, String doc) {
        this.updateSchema.addColumn(name, type, doc);
        this.moveColBeforePar(name);
        return this;
    }

    public UpdateSchema addColumn(String parent, String name, Type type, String doc) {
        this.updateSchema.addColumn(parent, name, type, doc);
        if (parent == null) {
            this.moveColBeforePar(name);
        }
        return this;
    }

    public UpdateSchema addRequiredColumn(String name, Type type, String doc) {
        throw new UnsupportedOperationException("hive table not support addRequiredColumn");
    }

    public UpdateSchema addRequiredColumn(String parent, String name, Type type, String doc) {
        throw new UnsupportedOperationException("hive table not support addRequiredColumn");
    }

    public UpdateSchema renameColumn(String name, String newName) {
        throw new UnsupportedOperationException("not support renameColumn now, there will be error when hive stored as parquet and we rename the column");
    }

    public UpdateSchema updateColumn(String name, Type.PrimitiveType newType) {
        this.updateSchema.updateColumn(name, newType);
        return this;
    }

    public UpdateSchema updateColumnDoc(String name, String newDoc) {
        this.updateSchema.updateColumnDoc(name, newDoc);
        return this;
    }

    public UpdateSchema makeColumnOptional(String name) {
        throw new UnsupportedOperationException("hive table not support makeColumnOptional");
    }

    public UpdateSchema requireColumn(String name) {
        throw new UnsupportedOperationException("hive table not support requireColumn");
    }

    public UpdateSchema deleteColumn(String name) {
        throw new UnsupportedOperationException("hive table not support deleteColumn");
    }

    public UpdateSchema moveFirst(String name) {
        throw new UnsupportedOperationException("hive table not support moveFirst");
    }

    public UpdateSchema moveBefore(String name, String beforeName) {
        throw new UnsupportedOperationException("hive table not support moveBefore");
    }

    public UpdateSchema moveAfter(String name, String afterName) {
        throw new UnsupportedOperationException("hive table not support moveAfter");
    }

    public UpdateSchema unionByNameWith(Schema newSchema) {
        throw new UnsupportedOperationException("hive table not support unionByNameWith");
    }

    public UpdateSchema setIdentifierFields(Collection<String> names) {
        throw new UnsupportedOperationException("hive table not support setIdentifierFields");
    }

    private void moveColBeforePar(String name) {
        if (!this.arcticTable.spec().isUnpartitioned()) {
            int parFieldMinIndex = Integer.MAX_VALUE;
            Types.NestedField firstParField = null;
            for (PartitionField partitionField : this.arcticTable.spec().fields()) {
                Types.NestedField sourceField = this.arcticTable.schema().findField(partitionField.sourceId());
                if (this.arcticTable.schema().columns().indexOf(sourceField) >= parFieldMinIndex) continue;
                parFieldMinIndex = this.arcticTable.schema().columns().indexOf(sourceField);
                firstParField = sourceField;
            }
            if (firstParField != null) {
                this.updateSchema.moveBefore(name, firstParField.name());
            }
        }
    }
}

