/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.op;

import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.op.BaseSchemaUpdate;
import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.table.ArcticTable;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.util.PropertyUtil;

public class HiveSchemaUpdate
extends BaseSchemaUpdate {
    private final ArcticTable arcticTable;
    private final HMSClientPool hiveClient;
    private final UpdateSchema updateSchema;

    public HiveSchemaUpdate(ArcticTable arcticTable, HMSClientPool hiveClient, UpdateSchema updateSchema) {
        super(arcticTable, updateSchema);
        this.arcticTable = arcticTable;
        this.hiveClient = hiveClient;
        this.updateSchema = updateSchema;
    }

    @Override
    public void commit() {
        this.updateSchema.commit();
        if (HiveTableUtil.loadHmsTable(this.hiveClient, this.arcticTable.id()) == null) {
            throw new RuntimeException(String.format("there is no such hive table named %s", this.arcticTable.id().toString()));
        }
        this.syncSchemaToHive();
    }

    private void syncSchemaToHive() {
        Table tbl = HiveTableUtil.loadHmsTable(this.hiveClient, this.arcticTable.id());
        if (tbl == null) {
            throw new RuntimeException(String.format("there is no such hive table named %s", this.arcticTable.id().toString()));
        }
        tbl.setSd(HiveTableUtil.storageDescriptor(this.arcticTable.schema(), this.arcticTable.spec(), tbl.getSd().getLocation(), FileFormat.valueOf((String)PropertyUtil.propertyAsString((Map)this.arcticTable.properties(), (String)"write.format.default", (String)"parquet").toUpperCase(Locale.ENGLISH))));
        HiveTableUtil.persistTable(this.hiveClient, tbl);
    }
}

