/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.op;

import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.exceptions.CannotAlterHiveLocationException;
import com.netease.arctic.hive.table.UnkeyedHiveTable;
import com.netease.arctic.hive.utils.HivePartitionUtil;
import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.op.UpdatePartitionProperties;
import com.netease.arctic.utils.FileUtil;
import com.netease.arctic.utils.TablePropertyUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;

public class ReplaceHivePartitions
implements ReplacePartitions {
    private final Transaction transaction;
    private final boolean insideTransaction;
    private final ReplacePartitions delegate;
    private final HMSClientPool hmsClient;
    private final HMSClientPool transactionalHMSClient;
    private final UnkeyedHiveTable table;
    private final List<DataFile> addFiles = Lists.newArrayList();
    private final String db;
    private final String tableName;
    private final Table hiveTable;
    private final Map<StructLike, Partition> rewritePartitions = Maps.newHashMap();
    private final Map<StructLike, Partition> newPartitions = Maps.newHashMap();
    private String unpartitionTableLocation;
    private int commitTimestamp;

    public ReplaceHivePartitions(Transaction transaction, boolean insideTransaction, UnkeyedHiveTable table, HMSClientPool client, HMSClientPool transactionalClient) {
        this.transaction = transaction;
        this.insideTransaction = insideTransaction;
        this.delegate = transaction.newReplacePartitions();
        this.hmsClient = client;
        this.transactionalHMSClient = transactionalClient;
        this.table = table;
        this.db = table.id().getDatabase();
        this.tableName = table.id().getTableName();
        try {
            this.hiveTable = (Table)client.run(c -> c.getTable(this.db, this.tableName));
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    public ReplacePartitions addFile(DataFile file) {
        this.delegate.addFile(file);
        String tableLocation = this.table.hiveLocation();
        String dataFileLocation = file.path().toString();
        if (dataFileLocation.toLowerCase().contains(tableLocation.toLowerCase())) {
            this.addFiles.add(file);
        }
        return this;
    }

    public ReplacePartitions validateAppendOnly() {
        this.delegate.validateAppendOnly();
        return this;
    }

    public ReplacePartitions set(String property, String value) {
        this.delegate.set(property, value);
        return this;
    }

    public ReplacePartitions deleteWith(Consumer<String> deleteFunc) {
        this.delegate.deleteWith(deleteFunc);
        return this;
    }

    public ReplacePartitions stageOnly() {
        this.delegate.stageOnly();
        return this;
    }

    public Snapshot apply() {
        return (Snapshot)this.delegate.apply();
    }

    public void commit() {
        if (!this.addFiles.isEmpty()) {
            this.commitTimestamp = (int)(System.currentTimeMillis() / 1000L);
            if (this.table.spec().isUnpartitioned()) {
                this.generateUnpartitionTableLocation();
            } else {
                this.applyHivePartitions();
            }
            this.delegate.commit();
            this.commitPartitionProperties();
            if (!this.insideTransaction) {
                this.transaction.commitTransaction();
            }
            if (this.table.spec().isUnpartitioned()) {
                this.commitUnPartitionedTable();
            } else {
                this.commitPartitionedTable();
            }
        }
    }

    private void commitPartitionProperties() {
        UpdatePartitionProperties updatePartitionProperties = this.table.updatePartitionProperties(this.transaction);
        if (this.table.spec().isUnpartitioned() && this.unpartitionTableLocation != null) {
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "hive-location", this.unpartitionTableLocation);
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "transient-time", this.commitTimestamp + "");
        } else {
            this.rewritePartitions.forEach((partitionData, partition) -> {
                updatePartitionProperties.set(partitionData, "hive-location", partition.getSd().getLocation());
                updatePartitionProperties.set(partitionData, "transient-time", this.commitTimestamp + "");
            });
            this.newPartitions.forEach((partitionData, partition) -> {
                updatePartitionProperties.set(partitionData, "hive-location", partition.getSd().getLocation());
                updatePartitionProperties.set(partitionData, "transient-time", this.commitTimestamp + "");
            });
        }
        updatePartitionProperties.commit();
    }

    public Object updateEvent() {
        return this.delegate.updateEvent();
    }

    private void applyHivePartitions() {
        Types.StructType partitionSchema = this.table.spec().partitionType();
        HashMap partitionLocationMap = Maps.newHashMap();
        HashMap partitionDataFileMap = Maps.newHashMap();
        HashMap partitionValueMap = Maps.newHashMap();
        for (DataFile d : this.addFiles) {
            List<String> partitionValues = HivePartitionUtil.partitionValuesAsList(d.partition(), partitionSchema);
            String value = Joiner.on((String)"/").join(partitionValues);
            String location = FileUtil.getFileDir((String)d.path().toString());
            partitionLocationMap.put(value, location);
            if (!partitionDataFileMap.containsKey(value)) {
                partitionDataFileMap.put(value, Lists.newArrayList());
            }
            ((List)partitionDataFileMap.get(value)).add(d);
            partitionValueMap.put(value, partitionValues);
        }
        partitionLocationMap.forEach((k, v) -> this.checkDataFileInSameLocation((String)v, (List)partitionDataFileMap.get(k)));
        for (String val : partitionValueMap.keySet()) {
            List values = (List)partitionValueMap.get(val);
            String location = (String)partitionLocationMap.get(val);
            List dataFiles = (List)partitionDataFileMap.get(val);
            try {
                Partition partition = (Partition)this.hmsClient.run(c -> c.getPartition(this.db, this.tableName, values));
                HivePartitionUtil.rewriteHivePartitions(partition, location, dataFiles, this.commitTimestamp);
                this.rewritePartitions.put(((DataFile)dataFiles.get(0)).partition(), partition);
            }
            catch (NoSuchObjectException e) {
                Partition p = HivePartitionUtil.newPartition(this.hiveTable, values, location, dataFiles, this.commitTimestamp);
                this.newPartitions.put(((DataFile)dataFiles.get(0)).partition(), p);
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void commitUnPartitionedTable() {
        if (!this.addFiles.isEmpty()) {
            String newDataLocation = FileUtil.getFileDir((String)this.addFiles.get(0).path().toString());
            try {
                this.transactionalHMSClient.run(c -> {
                    Table tbl = c.getTable(this.db, this.tableName);
                    tbl.getSd().setLocation(newDataLocation);
                    HiveTableUtil.generateTableProperties(this.commitTimestamp, this.addFiles).forEach((key, value) -> this.hiveTable.getParameters().put(key, value));
                    c.alterTable(this.db, this.tableName, tbl);
                    return 0;
                });
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void commitPartitionedTable() {
        try {
            this.transactionalHMSClient.run(c -> {
                if (!this.rewritePartitions.isEmpty()) {
                    try {
                        c.alterPartitions(this.db, this.tableName, Lists.newArrayList(this.rewritePartitions.values()), null);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!this.newPartitions.isEmpty()) {
                    c.addPartitions(Lists.newArrayList(this.newPartitions.values()));
                }
                return 0;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkDataFileInSameLocation(String partitionLocation, List<DataFile> files) {
        Path partitionPath = new Path(partitionLocation);
        for (DataFile df : files) {
            String fileDir = FileUtil.getFileDir((String)df.path().toString());
            Path dirPath = new Path(fileDir);
            if (partitionPath.equals((Object)dirPath)) continue;
            throw new CannotAlterHiveLocationException("can't create new hive location: " + partitionLocation + " for data file: " + df.path().toString() + " is not under partition location path");
        }
    }

    private void generateUnpartitionTableLocation() {
        this.unpartitionTableLocation = FileUtil.getFileDir((String)this.addFiles.get(0).path().toString());
    }
}

