/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.op;

import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.op.UpdateHiveFiles;
import com.netease.arctic.hive.table.UnkeyedHiveTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Transaction;

public class RewriteHiveFiles
extends UpdateHiveFiles<RewriteFiles>
implements RewriteFiles {
    private final RewriteFiles delegate;

    public RewriteHiveFiles(Transaction transaction, boolean insideTransaction, UnkeyedHiveTable table, HMSClientPool hmsClient, HMSClientPool transactionClient) {
        super(transaction, insideTransaction, table, hmsClient, transactionClient);
        this.delegate = transaction.newRewrite();
    }

    @Override
    SnapshotUpdate<?> getSnapshotUpdateDelegate() {
        return this.delegate;
    }

    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd) {
        this.delegate.rewriteFiles(filesToDelete, filesToAdd);
        this.markHiveFiles(filesToDelete, filesToAdd);
        return this;
    }

    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd, long sequenceNumber) {
        this.delegate.rewriteFiles(filesToDelete, filesToAdd, sequenceNumber);
        this.markHiveFiles(filesToDelete, filesToAdd);
        return this;
    }

    public RewriteFiles rewriteFiles(Set<DataFile> dataFilesToReplace, Set<DeleteFile> deleteFilesToReplace, Set<DataFile> dataFilesToAdd, Set<DeleteFile> deleteFilesToAdd) {
        this.delegate.rewriteFiles(dataFilesToReplace, deleteFilesToReplace, dataFilesToAdd, deleteFilesToAdd);
        this.markHiveFiles(dataFilesToReplace, dataFilesToAdd);
        return this;
    }

    private void markHiveFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd) {
        String hiveLocationRoot = this.table.hiveLocation();
        this.addFiles.addAll(this.getDataFilesInHiveLocation(filesToAdd, hiveLocationRoot));
        this.deleteFiles.addAll(this.getDataFilesInHiveLocation(filesToDelete, hiveLocationRoot));
    }

    public RewriteFiles validateFromSnapshot(long snapshotId) {
        this.delegate.validateFromSnapshot(snapshotId);
        return this;
    }

    public RewriteFiles set(String property, String value) {
        if ("txId".equals(property)) {
            this.txId = Long.parseLong(value);
        }
        if ("validate-location".equals(property)) {
            this.validateLocation = Boolean.parseBoolean(value);
        }
        this.delegate.set(property, value);
        return this;
    }

    public RewriteFiles deleteWith(Consumer<String> deleteFunc) {
        this.delegate.deleteWith(deleteFunc);
        return this;
    }

    public RewriteFiles stageOnly() {
        this.delegate.stageOnly();
        return this;
    }

    public Snapshot apply() {
        return (Snapshot)this.delegate.apply();
    }

    public Object updateEvent() {
        return this.delegate.updateEvent();
    }

    private List<DataFile> getDataFilesInHiveLocation(Set<DataFile> dataFiles, String hiveLocation) {
        ArrayList<DataFile> result = new ArrayList<DataFile>();
        for (DataFile dataFile : dataFiles) {
            String dataFileLocation = dataFile.path().toString();
            if (!dataFileLocation.toLowerCase().contains(hiveLocation.toLowerCase())) continue;
            result.add(dataFile);
        }
        return result;
    }
}

