/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.table;

import com.netease.arctic.AmsClient;
import com.netease.arctic.ams.api.TableMeta;
import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.op.BaseSchemaUpdate;
import com.netease.arctic.hive.table.SupportHive;
import com.netease.arctic.hive.table.UnkeyedHiveTable;
import com.netease.arctic.hive.utils.HiveMetaSynchronizer;
import com.netease.arctic.io.ArcticFileIO;
import com.netease.arctic.scan.BaseChangeTableIncrementalScan;
import com.netease.arctic.scan.ChangeTableIncrementalScan;
import com.netease.arctic.table.ArcticTable;
import com.netease.arctic.table.BaseKeyedTable;
import com.netease.arctic.table.BaseTable;
import com.netease.arctic.table.BaseUnkeyedTable;
import com.netease.arctic.table.ChangeTable;
import com.netease.arctic.table.PrimaryKeySpec;
import com.netease.arctic.table.TableIdentifier;
import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.util.PropertyUtil;

public class KeyedHiveTable
extends BaseKeyedTable
implements SupportHive {
    private final HMSClientPool hiveClient;

    public KeyedHiveTable(TableMeta tableMeta, String tableLocation, PrimaryKeySpec primaryKeySpec, AmsClient client, HMSClientPool hiveClient, UnkeyedHiveTable baseTable, ChangeTable changeTable) {
        super(tableMeta, tableLocation, primaryKeySpec, client, (BaseTable)baseTable, changeTable);
        this.hiveClient = hiveClient;
        this.syncHiveSchemaToArctic();
        this.syncHiveDataToArctic();
    }

    public void refresh() {
        super.refresh();
        this.syncHiveSchemaToArctic();
        this.syncHiveDataToArctic();
    }

    @Override
    public String hiveLocation() {
        return ((SupportHive)this.baseTable()).hiveLocation();
    }

    private void syncHiveSchemaToArctic() {
        if (PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-schema-change", (boolean)true)) {
            HiveMetaSynchronizer.syncHiveSchemaToArctic((ArcticTable)this, this.hiveClient);
        }
    }

    private void syncHiveDataToArctic() {
        if (PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-data-write", (boolean)false)) {
            HiveMetaSynchronizer.syncHiveDataToArctic((ArcticTable)this, this.hiveClient);
        }
    }

    @Override
    public HMSClientPool getHMSClient() {
        return this.hiveClient;
    }

    public static class HiveChangeInternalTable
    extends BaseUnkeyedTable
    implements ChangeTable {
        public HiveChangeInternalTable(TableIdentifier tableIdentifier, Table changeIcebergTable, ArcticFileIO arcticFileIO, AmsClient client) {
            super(tableIdentifier, changeIcebergTable, arcticFileIO, client);
        }

        public UpdateSchema updateSchema() {
            return new BaseSchemaUpdate((ArcticTable)this, super.updateSchema());
        }

        public ChangeTableIncrementalScan newChangeScan() {
            return new BaseChangeTableIncrementalScan((ChangeTable)this);
        }
    }
}

