/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.table;

import com.netease.arctic.AmsClient;
import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.op.HiveOperationTransaction;
import com.netease.arctic.hive.op.HiveSchemaUpdate;
import com.netease.arctic.hive.op.OverwriteHiveFiles;
import com.netease.arctic.hive.op.ReplaceHivePartitions;
import com.netease.arctic.hive.op.RewriteHiveFiles;
import com.netease.arctic.hive.table.SupportHive;
import com.netease.arctic.hive.utils.HiveMetaSynchronizer;
import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.io.ArcticFileIO;
import com.netease.arctic.table.ArcticTable;
import com.netease.arctic.table.BaseTable;
import com.netease.arctic.table.BaseUnkeyedTable;
import com.netease.arctic.table.TableIdentifier;
import java.util.Map;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.util.PropertyUtil;

public class UnkeyedHiveTable
extends BaseUnkeyedTable
implements BaseTable,
SupportHive {
    private final HMSClientPool hiveClient;
    private final String tableLocation;
    private boolean syncHiveChange = true;

    public UnkeyedHiveTable(TableIdentifier tableIdentifier, Table icebergTable, ArcticFileIO arcticFileIO, String tableLocation, AmsClient client, HMSClientPool hiveClient) {
        this(tableIdentifier, icebergTable, arcticFileIO, tableLocation, client, hiveClient, true);
    }

    public UnkeyedHiveTable(TableIdentifier tableIdentifier, Table icebergTable, ArcticFileIO arcticFileIO, String tableLocation, AmsClient client, HMSClientPool hiveClient, boolean syncHiveChange) {
        super(tableIdentifier, icebergTable, arcticFileIO, client);
        this.hiveClient = hiveClient;
        this.tableLocation = tableLocation;
        this.syncHiveChange = syncHiveChange;
        this.syncHiveSchemaToArctic();
        this.syncHiveDataToArctic();
    }

    public void refresh() {
        super.refresh();
        this.syncHiveSchemaToArctic();
        this.syncHiveDataToArctic();
    }

    public Schema schema() {
        return super.schema();
    }

    public ReplacePartitions newReplacePartitions() {
        return new ReplaceHivePartitions(super.newTransaction(), false, this, this.hiveClient, this.hiveClient);
    }

    public String name() {
        return this.id().getTableName();
    }

    @Override
    public String hiveLocation() {
        return this.properties().containsKey("base.hive.location-root") ? (String)this.properties().get("base.hive.location-root") : HiveTableUtil.hiveRootLocation(this.tableLocation);
    }

    @Override
    public HMSClientPool getHMSClient() {
        return this.hiveClient;
    }

    public OverwriteHiveFiles newOverwrite() {
        return new OverwriteHiveFiles(super.newTransaction(), false, this, this.hiveClient, this.hiveClient);
    }

    public RewriteHiveFiles newRewrite() {
        return new RewriteHiveFiles(super.newTransaction(), false, this, this.hiveClient, this.hiveClient);
    }

    public Transaction newTransaction() {
        Transaction transaction = super.newTransaction();
        return new HiveOperationTransaction(this, transaction, this.hiveClient);
    }

    public UpdateSchema updateSchema() {
        return new HiveSchemaUpdate((ArcticTable)this, this.hiveClient, super.updateSchema());
    }

    private void syncHiveSchemaToArctic() {
        if (this.syncHiveChange && PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-schema-change", (boolean)true)) {
            HiveMetaSynchronizer.syncHiveSchemaToArctic((ArcticTable)this, this.hiveClient);
        }
    }

    private void syncHiveDataToArctic() {
        if (this.syncHiveChange && PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-data-write", (boolean)false)) {
            HiveMetaSynchronizer.syncHiveDataToArctic((ArcticTable)this, this.hiveClient);
        }
    }
}

