/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class ChangeFieldName
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final ChangeType changeType;
    private final Set<String> fieldNameSet = Sets.newHashSet();

    ChangeFieldName(ChangeType changeType) {
        this.changeType = changeType;
    }

    private String changeName(String name) {
        switch (this.changeType) {
            case TO_UPPERCASE: {
                return name.toUpperCase(Locale.ROOT);
            }
            case TO_LOWERCASE: {
                return name.toLowerCase(Locale.ROOT);
            }
        }
        throw new UnsupportedOperationException("Unsupported change type: " + (Object)((Object)this.changeType));
    }

    public Type schema(Schema schema, Supplier<Type> future) {
        return future.get();
    }

    public Type struct(Types.StructType struct, Iterable<Type> futures) {
        List fields = struct.fields();
        int length = struct.fields().size();
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)length);
        Iterator<Type> types = futures.iterator();
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            Type type = types.next();
            if (field.isOptional()) {
                newFields.add(Types.NestedField.optional((int)field.fieldId(), (String)this.changeName(field.name()), (Type)type, (String)field.doc()));
            } else {
                newFields.add(Types.NestedField.required((int)field.fieldId(), (String)this.changeName(field.name()), (Type)type, (String)field.doc()));
            }
            if (this.fieldNameSet.contains(((Types.NestedField)newFields.get(i)).name())) {
                throw new IllegalArgumentException("Multiple fields' name will be changed to " + ((Types.NestedField)newFields.get(i)).name());
            }
            this.fieldNameSet.add(((Types.NestedField)newFields.get(i)).name());
        }
        return Types.StructType.of((List)newFields);
    }

    public Type field(Types.NestedField field, Supplier<Type> future) {
        return future.get();
    }

    public Type list(Types.ListType list, Supplier<Type> future) {
        return list;
    }

    public Type map(Types.MapType map, Supplier<Type> keyFuture, Supplier<Type> valueFuture) {
        return map;
    }

    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }

    static enum ChangeType {
        TO_UPPERCASE,
        TO_LOWERCASE;

    }
}

