package com.netease.cloudmusic.iotsdk.sdkbase.base.network.config

import com.netease.cloudmusic.iotsdk.sdkbase.base.network.interceptor.HttpLoggingInterceptor
import com.netease.cloudmusic.iotsdk.sdkbase.base.network.interceptor.RequestInterceptor
import androidx.annotation.Keep
import com.netease.cloudmusic.iotsdk.sdkbase.base.network.interceptor.*
import com.netease.cloudmusic.iotsdk.sdkbase.utils.immutableListOf
import okhttp3.ConnectionSpec
import okhttp3.Dispatcher
import okhttp3.OkHttpClient
import okhttp3.internal.Util
import java.util.concurrent.TimeUnit

/**
 * 云音乐对于网络层的配置
 * created by chenchiyi on 2022/1/20 10:27
 */
@Keep
object CMNetworkConfig {
    var okHttpClient: OkHttpClient
    var openLog: Boolean
    var accessTokenRefreshHandler: IAccessTokenRefreshHandler? = null
    var noAccessTokenHandler: INoAccessTokenHandler? = null

    init {
        openLog = false
        okHttpClient = configOKHttpClient()
    }


    private fun configOKHttpClient(): OkHttpClient {
        val builder = configBuilder()
        val okHttpClient = builder
            .build()
        okHttpClient.dispatcher().maxRequestsPerHost = 20
        return okHttpClient
    }

    private fun configBuilder(): OkHttpClient.Builder {
        val builder = OkHttpClient.Builder().apply {
            dispatcher(
                Dispatcher(
                    KThreadPool.okHttpExecutor(
                        Util.threadFactory("OkHttp Dispatcher", false)
                    )
                )
            )
            readTimeout(HttpConst.TIME_OUT, TimeUnit.MILLISECONDS).writeTimeout(
                HttpConst.TIME_OUT,
                TimeUnit.MILLISECONDS
            ).connectTimeout(HttpConst.TIME_OUT, TimeUnit.MILLISECONDS)
            cookieJar(CMCookieStore)
            connectionSpecs(
                immutableListOf(
                    ConnectionSpec.MODERN_TLS,
                    ConnectionSpec.COMPATIBLE_TLS,
                    ConnectionSpec.CLEARTEXT
                )
            )
            // InitAccessTokenInterceptor RequestInterceptor 先后顺序不可颠倒
            addInterceptor(InitAccessTokenInterceptor())
            addInterceptor(AccessTokenRefreshInterceptor())
            addInterceptor(RequestInterceptor())
            if (openLog) {
                addInterceptor(HttpLoggingInterceptor().apply {
                    setLevel(HttpLoggingInterceptor.Level.BODY)
                })
            }
        }
        return builder
    }

}