package com.netease.cloudmusic.iotsdk.sdkbase.base.network.exception

import androidx.annotation.Keep
import java.io.IOException

/**
 * 网络层的异常都会被捕获，然后抛出这个异常
 * created by chenchiyi on 2022/1/21 16:39
 */

@Keep
class CMNetworkIOException : IOException {

    constructor(cause: Throwable?) : super(cause) {}
    constructor(cause: String?) : super(cause) {}

    override fun printStackTrace() {
        cause?.printStackTrace() ?: super.printStackTrace()
    }

    companion object {
        private const val serialVersionUID = 4108883799571801101L
    }
}