package com.netease.cloudmusic.iotsdk.sdkbase.base.network.interceptor

import android.util.Log

object HttpLogger {
    private var isLogEnable = false
    var tag = "IOTSDK_OKHttp"
    fun debug(isEnable: Boolean) {
        debug(tag, isEnable)
    }

    fun debug(logTag: String, isEnable: Boolean) {
        tag = logTag
        isLogEnable = isEnable
    }

    fun v(msg: String?) {
        v(tag, msg)
    }

    fun v(tag: String?, msg: String?) {
        if (msg == null) return
        if (isLogEnable) Log.v(tag, msg)
    }

    fun d(msg: String?) {
        d(tag, msg)
    }

    fun d(tag: String?, msg: String?) {
        if (msg == null) return
        if (isLogEnable) Log.d(tag, msg)
    }

    fun i(msg: String?) {
        i(tag, msg)
    }

    fun i(tag: String?, msg: String?) {
        if (msg == null) return
        if (isLogEnable) Log.i(tag, msg)
    }

    fun w(msg: String?) {
        w(tag, msg)
    }

    fun w(tag: String?, msg: String?) {
        if (msg == null) return
        if (isLogEnable) Log.w(tag, msg)
    }

    fun e(t: Throwable) {
        t.printStackTrace()
    }
}