package com.netease.cloudmusic.iotsdk.sdkbase.base.network.interceptor

import com.netease.cloudmusic.iotsdk.sdkbase.base.network.config.CMNetworkConfig
import com.netease.cloudmusic.iotsdk.sdkbase.base.network.const.ParamConst
import com.netease.cloudmusic.iotsdk.sdkbase.base.storage.mmkv.CMSharedPreferences
import com.netease.cloudmusic.iotsdk.sdkbase.utils.CMSDKLogUtils
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException
import java.util.concurrent.locks.ReentrantLock

/**
 * 初始化 AccessToken 拦截器 检测到无 AccessToken 时自动处理（尝试匿名登录）
 * @Author dengyongbiao
 * @Time 2022/12/27 11:17:43
 */
class InitAccessTokenInterceptor : Interceptor {
    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val request = chain.request()
        val host = request.url()
        val url = request.url().toString()
        if (!isAnonymousLoginRequest(url) &&
            noAccessToken() &&
            sFetchLoginInfoLock.holdCount == 0
        ) {
            CMSDKLogUtils.i(TAG, "Before Lock url:" + url + "， thread:" + Thread.currentThread().id)
            // 重入锁保证只有第一个线程可以抢占到
            sFetchLoginInfoLock.lock()
            CMSDKLogUtils.i(TAG, "Lock Url:" + url + "， thread:" + Thread.currentThread().id)
            try {
                if (noAccessToken()) {
                    CMNetworkConfig.noAccessTokenHandler?.onNoAccessTokenHandle()
                }
            } finally {
                CMSDKLogUtils.i(TAG,
                    "Unlock Url:" + url + "， thread:" + Thread.currentThread().id
                )
                sFetchLoginInfoLock.unlock()
            }
        }
        return chain.proceed(request)
    }

    private fun noAccessToken(): Boolean {
        return CMSharedPreferences.getString(ParamConst.ACCESS_TOKEN).isNullOrBlank()
    }

    private fun isAnonymousLoginRequest(url: String): Boolean {
        return url.contains("/openapi/music/basic/oauth2/login/anonymous")
    }

    companion object {
        private const val TAG = "InitAccessTokenInterceptor"
        private val sFetchLoginInfoLock = ReentrantLock()
    }
}