package com.netease.cloudmusic.iotsdk.sdkbase.base.network.interceptor

import okhttp3.Interceptor
import okhttp3.Response

/**
 * 请求添加统一参数
 * 比如sign，device
 * created by chenchiyi on 2022/1/25 09:47
 */
class RequestInterceptor : Interceptor {

    companion object {
        private const val METHOD_GET = "GET"
        private const val METHOD_POST = "POST"
        private const val HEADER_KEY_USER_AGENT = "User-Agent"
    }

    override fun intercept(chain: Interceptor.Chain): Response {
        val request = chain.request()
        val requestBuilder = request.newBuilder()

        when (request.method()) {
            METHOD_GET -> {
                addParamsForGET(requestBuilder, request)
            }
            METHOD_POST -> {
                addParamsForPOST(requestBuilder, request)
            }
        }
        return chain.proceed(requestBuilder.build())
    }
}