package com.netease.cloudmusic.iotsdk.sdkbase.base.network.interceptor

import com.netease.cloudmusic.iotsdk.sdkbase.base.network.const.ParamConst
import com.netease.cloudmusic.iotsdk.sdkbase.base.oauth.OAuthConst
import com.netease.cloudmusic.iotsdk.sdkbase.base.oauth.SignUtils
import com.netease.cloudmusic.iotsdk.sdkbase.base.storage.mmkv.CMSharedPreferences
import okhttp3.FormBody
import okhttp3.HttpUrl
import okhttp3.Request
import org.json.JSONObject

/**
 * 处理请求过程中的参数
 * created by chenchiyi on 2022/1/25 17:24
 */

fun addParamsForGET(requestBuilder: Request.Builder, request: Request) {
    val urlBuilder = request.url().newBuilder()
    val tempUrl = urlBuilder.build()
    // 将所有业务参数组装在bizContent中
    val bizContentJson = JSONObject()
    for (i in 0 until tempUrl.querySize()) {
        bizContentJson.put(tempUrl.queryParameterName(i), tempUrl.queryParameterValue(i))
    }
    urlBuilder.addPublicParams(bizContentJson.toString())
    val httpUrl = urlBuilder.build()

    // 获取所有get参数
    val paramKeys = httpUrl.queryParameterNames()
    val params = mutableMapOf<String, String?>()
    paramKeys.forEachIndexed { index, key ->
        params[key] = httpUrl.queryParameterValue(index)
    }
    // 对参数进行签名
    val sign = SignUtils.sign(params)
    urlBuilder.addQueryParameter(ParamConst.SIGN, sign)
    requestBuilder.url(httpUrl)
}

fun addParamsForPOST(requestBuilder: Request.Builder, request: Request) {
    // FormBody和url不太一样，若需添加公共参数，需要新建一个构造器
    val bodyBuilder = FormBody.Builder()
    val formBody = request.body() as? FormBody
    // 将所有业务参数组装在bizContent中
    val bizContentJson = JSONObject()
    formBody?.let {
        for (i in 0 until formBody.size()) {
            bizContentJson.put(formBody.name(i), formBody.value(i))
        }
    }
    bodyBuilder.addPublicParams(bizContentJson.toString())
    // 获取所有post参数
    val params = mutableMapOf<String, String?>()
    val tempBuilder = bodyBuilder.build()
    for (i in 0 until tempBuilder.size()) {
        params[tempBuilder.name(i)] = tempBuilder.value(i)
    }
    // 对参数进行签名
    val sign = SignUtils.sign(params)
    bodyBuilder.add(ParamConst.SIGN, sign)
    requestBuilder.post(bodyBuilder.build())
}

private fun HttpUrl.Builder.addPublicParams(bizContent: String) {
    addEncodedQueryParameter(ParamConst.APP_ID, OAuthConst.appId)
    addEncodedQueryParameter(ParamConst.SIGN_TYPE, ParamConst.RSA_SHA256)
    addEncodedQueryParameter(ParamConst.TIMESTAMP, System.currentTimeMillis().toString())
    addEncodedQueryParameter(ParamConst.BIZ_CONTENT, bizContent)
    val deviceJson = buildDeviceJson()
    addEncodedQueryParameter(ParamConst.DEVICE, deviceJson)
    // 除开匿名登录接口，都需要带上token
    CMSharedPreferences.getString(ParamConst.ACCESS_TOKEN)
        .takeIf { !it.isNullOrBlank() }?.let { token ->
            addEncodedQueryParameter(ParamConst.ACCESS_TOKEN, token)
        }
}

private fun FormBody.Builder.addPublicParams(bizContent: String) {
    addEncoded(ParamConst.APP_ID, OAuthConst.appId)
    addEncoded(ParamConst.SIGN_TYPE, ParamConst.RSA_SHA256)
    addEncoded(ParamConst.TIMESTAMP, System.currentTimeMillis().toString())
    addEncoded(ParamConst.BIZ_CONTENT, bizContent)
    val deviceJson = buildDeviceJson()
    addEncoded(ParamConst.DEVICE, deviceJson)
    // 除开匿名登录接口，都需要带上token
    CMSharedPreferences.getString(ParamConst.ACCESS_TOKEN)
        .takeIf { !it.isNullOrBlank() }?.let { token ->
            addEncoded(ParamConst.ACCESS_TOKEN, token)
        }
}

private fun buildDeviceJson(): String {
    return JSONObject().apply {
        put(ParamConst.CHANNEL, OAuthConst.deviceInfo.channel)
        put(ParamConst.DEVICE_ID, OAuthConst.deviceInfo.deviceId)
        put(ParamConst.DEVICE_TYPE, OAuthConst.deviceInfo.deviceType)
        put(ParamConst.APP_VER, OAuthConst.deviceInfo.appVer)
        put(ParamConst.OS, OAuthConst.deviceInfo.os)
        put(ParamConst.OS_VER, OAuthConst.deviceInfo.osVer)
        put(ParamConst.BRAND, OAuthConst.deviceInfo.brand)
        put(ParamConst.MODEL, OAuthConst.deviceInfo.model)
        put(ParamConst.CLIENT_IP, OAuthConst.deviceInfo.clientIp)
    }.toString()
}