package com.netease.cloudmusic.iotsdk.sdkbase.base.network.retrofit

import androidx.annotation.Keep
import com.netease.cloudmusic.iotsdk.sdkbase.base.network.exception.CMNetworkIOException
import com.squareup.moshi.JsonClass
import java.net.HttpURLConnection

/**
 * API的请求返回封装成这个类
 * created by chenchiyi on 2022/1/21 16:38
 */
@Keep
@JsonClass(generateAdapter = true)
data class ApiResult<Data>(
    var code: Int = HttpURLConnection.HTTP_OK,
    var subCode: Int = HttpURLConnection.HTTP_OK,
    var message: String? = null,
    @Transient
    var exception: CMNetworkIOException? = null,
    var httpCode: Int = HttpURLConnection.HTTP_OK,
    var data: Data? = null
) {

    companion object {

        fun <Data> success(data: Data): ApiResult<Data> {
            return ApiResult(data = data)
        }

        fun <Data> exception(exception: CMNetworkIOException): ApiResult<Data> {
            return ApiResult(0, exception = exception)
        }

        fun <Data> wrap(ret: ApiResult<*>): ApiResult<Data> {
            return ApiResult(ret.code, ret.subCode, ret.message, ret.exception, ret.httpCode)
        }
    }

    fun isSuccess(): Boolean {
        return exception == null && 200 <= code && code < 300
    }

    override fun toString(): String {
        return "ApiResult(code=$code, message=$message, exception=$exception, httpCode=$httpCode, data=$data)"
    }
}