package com.netease.cloudmusic.iotsdk.sdkbase.base.network.retrofit

import androidx.annotation.Keep
import com.netease.cloudmusic.iotsdk.sdkbase.base.network.config.CMDomainConfig
import com.netease.cloudmusic.iotsdk.sdkbase.base.network.config.CMNetworkConfig
import com.netease.cloudmusic.iotsdk.sdkbase.base.network.retrofit.convert.CMMoshiConverterFactory
import com.squareup.moshi.Moshi
import retrofit2.Retrofit

/**
 * 网络库
 * created by chenchiyi on 2022/1/20 10:00
 */
@Keep
object CMRetrofit {

    private const val TAG = "CMRetrofit"
    private val _moshi by lazy {
        Moshi.Builder().add(NullSafeAdapter).build()
    }

    private fun getRetrofitWithUrl(baseUrl: String? = null): Retrofit {
        return RELEASE
    }

    @Keep
    fun getRetrofit(): Retrofit {
        return getRetrofitWithUrl()
    }

    private fun getMoshi(): Moshi = _moshi

    private val RELEASE: Retrofit by lazy {
        val rawClient = CMNetworkConfig.okHttpClient
        val builder = rawClient.newBuilder()
        val baseUrl: String = CMDomainConfig.getApiBaseUrl()
        val retrofit = Retrofit.Builder()
            .baseUrl(baseUrl)
            .addConverterFactory(CMMoshiConverterFactory.create(getMoshi()))
            .client(builder.build())
            .build()
        retrofit
    }
}