package com.netease.cloudmusic.iotsdk.sdkbase.base.network.retrofit

import androidx.annotation.Keep

/**
 * created by chenchiyi on 2022/2/16 17:29
 */
@Keep
sealed class State<out T : Any?> {

    @Keep
    companion object {
        fun <T> success(data: T): SUCCESS<T> {
            return SUCCESS(data)
        }

        fun error(error: Throwable? = null,
                      code: Int? = null,
                      message: String? = null,
                      subCode: Int? = null): ERROR {
            return ERROR(error, code, message, subCode)
        }
    }
}

@Keep
object LOADING : State<Nothing>()

@Keep
data class SUCCESS<out T : Any?>(val data: T) : State<T>()

@Keep
data class ERROR(
    val error: Throwable? = null,
    var code: Int? = null,
    var message: String? = null,
    var subCode: Int? = null
) : State<Nothing>()
