package com.netease.cloudmusic.iotsdk.sdkbase.base.network.retrofit.convert

import com.squareup.moshi.Moshi
import com.squareup.moshi.internal.Util
import okhttp3.RequestBody
import okhttp3.ResponseBody
import retrofit2.Converter
import retrofit2.Retrofit
import retrofit2.converter.moshi.MoshiConverterFactory
import java.lang.reflect.Type

class CMMoshiConverterFactory private constructor(
    private val moshi: Moshi,
) : Converter.Factory() {

    val factory: MoshiConverterFactory = MoshiConverterFactory.create(moshi)

    override fun responseBodyConverter(
        type: Type,
        annotations: Array<out Annotation>,
        retrofit: Retrofit
    ): Converter<ResponseBody, *>? {
        return CMMoshiResponseBodyConverter<Any>(
            moshi.adapter(
                type,
                Util.jsonAnnotations(annotations)
            )
        )
    }

    override fun requestBodyConverter(
        type: Type,
        parameterAnnotations: Array<Annotation>,
        methodAnnotations: Array<Annotation>,
        retrofit: Retrofit
    ): Converter<*, RequestBody>? {
        return factory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit)
    }

    companion object {
        fun create(moshi: Moshi?): CMMoshiConverterFactory {
            if (moshi == null) throw NullPointerException("moshi == null")
            return CMMoshiConverterFactory(moshi)
        }
    }
}