package com.netease.cloudmusic.iotsdk.sdkbase.base.network.retrofit.mvvm

/**
 * created by chenchiyi on 2022/1/21 16:43
 */
open class ParamResource<P, R>(
    override val status: Status,
    var param: P?,
    override val data: R? = null,
    override val error: Throwable? = null,
    override var code: Int = 0,
    override var message: String? = null
) : Resource<R>(status, data, error) {

    companion object {
        fun <P, R> success(param: P?, data: R?): ParamResource<P, R> {
            return ParamResource(Status.SUCCESS, param, data)
        }

        fun <P, R> error(
            param: P?, data: R? = null, error: Throwable? = null,
            code: Int = 0, message: String? = null
        ): ParamResource<P, R> {
            return ParamResource(Status.ERROR, param, data, error, code, message)
        }

        fun <P, R> loading(param: P?): ParamResource<P, R> {
            return ParamResource(Status.LOADING, param)
        }
    }
}