package com.netease.cloudmusic.iotsdk.sdkbase.base.network.retrofit.mvvm

enum class Status {
    READY,
    SUCCESS,
    ERROR,
    LOADING,
    EMPTY,
    NOMORE,
    INSERTED,
    REMOVED,
    CLEAR,
    SET,
    CHANGE,
    BATCH
}

open class Resource<out T>(open val status: Status, open val data: T?, open val error: Throwable?) {

    open var code : Int = 0
    open var message : String? = null
    var rParam : Any? = null

    companion object {
        private const val CODE_SUCCESS = 200

        // 无param
        fun <T> success(data: T?): Resource<T> {
            return success(data, CODE_SUCCESS, null)
        }

        // 无param
        fun <T> success(data: T?, code: Int): Resource<T> {
            return success(data, code, null)
        }

        // 有param
        fun <T> success(data: T?, param: Any?): Resource<T> {
            return success(data, CODE_SUCCESS, param)
        }

        fun <T> success(data: T?, code: Int, param: Any?): Resource<T> {
            val resource = Resource(Status.SUCCESS, data, null)
            resource.code = code
            resource.rParam = param
            return resource
        }

        fun <T> error(error: Throwable?, data: T?, code : Int, msg : String?): Resource<T> {
            return error(error, data, code, msg, null)
        }

        fun <T> error(error: Throwable?, data: T?, code : Int, msg : String?, param : Any?): Resource<T> {
            val resource = Resource(Status.ERROR, data, error)
            resource.code = code
            resource.message = msg
            resource.rParam = param
            return resource
        }

        fun <T> loading(data: T?): Resource<T> {
            return loading(data, null)
        }

        fun <T> loading(data: T?, param: Any?): Resource<T> {
            val resource = Resource(Status.LOADING, data, null)
            resource.rParam = param
            return resource
        }

        fun <T> empty(): Resource<T> {
            return Resource(Status.EMPTY, null, null)
        }

        fun <T> nomore(): Resource<T> {
            return Resource(Status.NOMORE, null, null)
        }
    }

    fun isSuccess() : Boolean {
        return status == Status.SUCCESS
    }
    fun isLoading() : Boolean {
        return status == Status.LOADING
    }

    fun isError() : Boolean {
        return status == Status.ERROR
    }

}