package com.netease.cloudmusic.iotsdk.sdkbase.base.oauth

import androidx.annotation.Keep
import com.netease.cloudmusic.iotsdk.sdkbase.config.DeviceInfo
import com.netease.cloudmusic.iotsdk.sdkbase.config.SDKConfig

/**
 * created by chenchiyi on 2022/1/25 14:29
 */
@Keep
object OAuthConst {

    const val ERROR_CODE_DEVICE_INFO_NULL = "DEVICE_INFO_NULL"
    const val ERROR_CODE_APP_INFO_NULL = "APP_INFO_NULL"

    private const val ERROR_MSG_DEVICE_INFO_NULL = "DeviceInfo could not be null!"
    private const val ERROR_MSG_APP_INFO_NULL = "appId，appSecret and priKey could not be null or empty!"

    lateinit var sdkConfig: SDKConfig
    lateinit var deviceInfo: DeviceInfo
    var priKey: String = ""
    var appId: String = ""
    var appSecret: String = ""

    fun transConfig(sdkConfig: SDKConfig): Triple<Boolean, String, String> {
        this.sdkConfig = sdkConfig
        if (sdkConfig.deviceInfo == null) {
            return Triple(false, ERROR_CODE_DEVICE_INFO_NULL, ERROR_MSG_DEVICE_INFO_NULL)
        }
        this.deviceInfo = sdkConfig.deviceInfo
        priKey = this.sdkConfig.rsaPriKey
        appId = this.sdkConfig.appId
        appSecret = this.sdkConfig.appSecret
        if (appId.isBlank() || appSecret.isBlank() || priKey.isBlank()) {
            return Triple(false, ERROR_CODE_APP_INFO_NULL, ERROR_MSG_APP_INFO_NULL)
        }
        return Triple(true, "", "")
    }
}