package com.netease.cloudmusic.iotsdk.sdkbase.base.storage.mmkv

import android.content.Context
import android.content.SharedPreferences
import androidx.annotation.Keep
import com.netease.cloudmusic.iotsdk.sdkbase.config.SDKConfig
import com.tencent.mmkv.MMKV

/**
 * created by chenchiyi on 2022/1/20 15:53
 */
@Keep
object CMSharedPreferences : MultiProcessSp {

    var impl: MultiProcessSp? = null

    const val PREFERENCE_NAME_CLOUD_MUSIC: String = "com.netease.cloudmusic.preferences"
    const val MULTI_PROCESS_SETTINGS_FILE = "multiprocess_settings"

    fun init(context: Context, sdkConfig: SDKConfig) {
        if (sdkConfig.localPersistentStorage == null) {
            MMKV.initialize(context)
        } else {
            impl = sdkConfig.localPersistentStorage
        }
    }

    fun getInt(key: String, defValue: Int): Int {
        return getMainPreference().getInt(key, defValue)
    }

    fun putInt(key: String, value: Int) {
        getMainPreference().edit().putInt(key, value).apply()
    }

    fun getString(key: String, defValue: String? = null): String? {
        return getMainPreference().getString(key, defValue)
    }

    fun putString(key: String, value: String?) {
        getMainPreference().edit().putString(key, value).apply()
    }

    fun putBoolean(key: String, value: Boolean) {
        getMainPreference().edit().putBoolean(key, value).apply()
    }

    fun getBoolean(key: String, defValue: Boolean = false): Boolean {
        return getMainPreference().getBoolean(key, defValue)
    }

    fun putLong(key: String, value: Long) {
        getMainPreference().edit().putLong(key, value).apply()
    }

    fun getLong(key: String, defValue: Long): Long {
        return getMainPreference().getLong(key, defValue)
    }

    fun clear() {
        getMainPreference().edit().clear().apply()
    }

    override fun getMainPreference(defName: String): SharedPreferences {
        return impl?.getMainPreference(defName) ?: MMKV.mmkvWithID(defName)
    }

    override fun getMultiProcessSettingPreference(defName: String): SharedPreferences {
        return impl?.getMultiProcessSettingPreference(defName) ?: MMKV.mmkvWithID(
            defName, MMKV.MULTI_PROCESS_MODE
        )
    }
}