package com.netease.cloudmusic.iotsdk.sdkbase.config

import androidx.annotation.Keep

/**
 * created by chenchiyi on 2022/3/1 16:40
 */
@Keep
class DeviceInfo private constructor(builder: Builder) {

    val channel: String
    val deviceId: String
    val deviceType: String
    val appVer: String
    val os: String
    val osVer: String
    val brand: String
    val model: String
    val clientIp: String?

    init {
        this.channel = builder.channel
        this.deviceId = builder.deviceId
        this.deviceType = builder.deviceType
        this.appVer = builder.appVer
        this.os = builder.os
        this.osVer = builder.osVer
        this.brand = builder.brand
        this.model = builder.model
        this.clientIp = builder.clientIp
    }

    @Keep
    class Builder {
        var channel: String = ""
            private set
        var deviceId: String = ""
            private set
        var deviceType: String = ""
            private set
        var appVer: String = ""
            private set
        var os: String = ""
            private set
        var osVer: String = ""
            private set
        var brand: String = ""
            private set
        var model: String = ""
            private set
        var clientIp: String = ""
            private set

        fun channel(channel: String) = apply {
            this.channel = channel
        }

        fun deviceId(deviceId: String) = apply {
            this.deviceId = deviceId
        }

        fun deviceType(deviceType: String) = apply {
            this.deviceType = deviceType
        }

        fun appVer(appVer: String) = apply {
            this.appVer = appVer
        }

        fun os(os: String) = apply {
            this.os = os
        }

        fun osVer(osVer: String) = apply {
            this.osVer = osVer
        }

        fun brand(brand: String) = apply {
            this.brand = brand
        }

        fun model(model: String) = apply {
            this.model = model
        }

        fun clientIp(clientIp: String) = apply {
            this.clientIp = clientIp
        }

        fun build() = DeviceInfo(this)
    }
}