package com.netease.cloudmusic.iotsdk.sdkbase.config

import android.media.AudioManager
import androidx.annotation.Keep
import com.netease.cloudmusic.iotsdk.sdkbase.base.storage.mmkv.MultiProcessSp

/**
 * created by chenchiyi on 2022/1/19 16:34
 */
@Keep
class SDKConfig private constructor(builder: Builder) {

    val appId: String
    val appSecret: String
    val rsaPriKey: String
    val deviceInfo: DeviceInfo?
    val localPersistentStorage: MultiProcessSp?
    val onAudioFocusChangeListener: AudioManager.OnAudioFocusChangeListener?
    val closeInnerAudioFocusAction: Boolean
    val enablePlayer: Boolean
    val enablePlayerNativeLog: Boolean
    val enableSdkLog: Boolean
    val cacheDirName: String?
    val cacheMaxSize: Long

    init {
        this.appId = builder.appId
        this.appSecret = builder.appSecret
        this.rsaPriKey = builder.rsaPriKey
        this.deviceInfo = builder.deviceInfo
        this.localPersistentStorage = builder.localPersistentStorage
        this.onAudioFocusChangeListener = builder.onAudioFocusChangeListener
        this.closeInnerAudioFocusAction = builder.closeInnerAudioFocusAction
        this.enablePlayer = builder.enablePlayer
        this.enablePlayerNativeLog = builder.enablePlayerNativeLog
        this.enableSdkLog = builder.enableSdkLog
        this.cacheDirName = builder.cacheDirName
        this.cacheMaxSize = builder.cacheMaxSize
    }

    @Keep
    class Builder {
        var appId: String = ""
            private set
        var appSecret: String = ""
            private set
        var rsaPriKey: String = ""
            private set
        var deviceInfo: DeviceInfo? = null
            private set
        var localPersistentStorage: MultiProcessSp? = null
            private set
        var onAudioFocusChangeListener: AudioManager.OnAudioFocusChangeListener? = null
            private set
        var closeInnerAudioFocusAction: Boolean = false
            private set
        var enablePlayer: Boolean = true
            private set
        var enablePlayerNativeLog: Boolean = true
            private set
        var enableSdkLog: Boolean = true
            private set
        var cacheDirName: String? = null
            private set
        var cacheMaxSize: Long = -1L
            private set

        fun appId(appId: String) = apply {
            this.appId = appId
        }

        fun appSecret(appSecret: String) = apply {
            this.appSecret = appSecret
        }

        fun rsaPriKey(rsaPriKey: String) = apply {
            this.rsaPriKey = rsaPriKey
        }

        fun deviceInfo(deviceInfo: DeviceInfo) = apply {
            this.deviceInfo = deviceInfo
        }

        fun localPersistentStorage(localPersistentStorage: MultiProcessSp) = apply {
            this.localPersistentStorage = localPersistentStorage
        }

        fun onAudioFocusChangeListener(onAudioFocusChangeListener: AudioManager.OnAudioFocusChangeListener) = apply {
            this.onAudioFocusChangeListener = onAudioFocusChangeListener
        }

        fun closeInnerAudioFocusAction(closeInnerAudioFocusAction: Boolean) = apply {
            this.closeInnerAudioFocusAction = closeInnerAudioFocusAction
        }

        fun enablePlayer(enablePlayer: Boolean) = apply {
            this.enablePlayer = enablePlayer
        }

        fun enablePlayerNativeLog(enablePlayerNativeLog: Boolean) = apply {
            this.enablePlayerNativeLog = enablePlayerNativeLog
        }

        fun enableSdkLog(enableSdkLog: Boolean) = apply {
            this.enableSdkLog = enableSdkLog
        }

        fun cacheDirName(cacheDirName: String) = apply {
            this.cacheDirName = cacheDirName
        }

        fun cacheMaxSize(cacheMaxSize: Long) = apply {
            this.cacheMaxSize = cacheMaxSize
        }

        fun build() = SDKConfig(this)
    }
}