package com.netease.cloudmusic.iotsdk.sdkbase.utils

import android.util.Log
import androidx.annotation.Keep

/**
 * SDK日志工具类
 * @Author dengyongbiao
 * @Time 2022/12/27 14:40:05
 */
@Keep
object CMSDKLogUtils {
    /** debug 等级日志是否开启 */
    private var enableDebug = true

    /** info 等级日志是否开启 */
    private var enableInfo = true

    /** warn 等级日志是否开启 */
    private var enableWarn = true

    /** error 等级日志是否开启 */
    private var enableError = true

    const val TAG = "CMSDKLog"

    fun enableLog(enable: Boolean) {
        enableDebug(enable)
        enableInfo(enable)
    }

    private fun getSDKVersion(): String {
        var version = "unknown"
        CmIotSDKContext.getAppContext()?.let { appContext ->
            version = CmIotSdkVersionUtils.getSdkVersion(appContext)
        }
        return version
    }

    fun enableDebug(enable: Boolean) {
        enableDebug = enable
    }

    fun enableInfo(enable: Boolean) {
        enableInfo = enable
    }

    fun enableWarn(enable: Boolean) {
        enableWarn = enable
    }

    fun enableError(enable: Boolean) {
        enableError = enable
    }

    fun d(tag: String, msg: String, tr: Throwable? = null) {
        if (enableDebug) {
            Log.d(TAG, "<${getSDKVersion()}>[$tag] $msg", tr)
        }
    }

    fun i(tag: String, msg: String, tr: Throwable? = null) {
        if (enableInfo) {
            Log.i(TAG, "<${getSDKVersion()}>[$tag] $msg", tr)
        }
    }

    fun w(tag: String, msg: String, tr: Throwable? = null) {
        if (enableWarn) {
            Log.w(TAG, "<${getSDKVersion()}>[$tag] $msg", tr)
        }
    }

    fun e(tag: String, msg: String, tr: Throwable? = null) {
        if (enableError) {
            Log.e(TAG, "<${getSDKVersion()}>[$tag] $msg", tr)
        }
    }
}