package com.netease.cloudmusic.iotsdk.sdkbase.utils

import android.content.Context
import android.content.pm.PackageManager
import androidx.annotation.Keep

/**
 * SDK版本工具类
 * @Author dengyongbiao
 * @Time 2023/04/18 10:59:22
 */
@Keep
object CmIotSdkVersionUtils {

    private var sdkVersion: String = ""

    /** 元数据key-版本 */
    private const val KEY_META_DATA_VERSION = "com.netease.cloudmusic.iotsdk.version"

    fun getSdkVersion(context: Context): String {
        if (sdkVersion.isNotBlank()) {
            return sdkVersion
        }
        sdkVersion = context.packageManager
            .getApplicationInfo(context.packageName, PackageManager.GET_META_DATA)
            .metaData
            .getString(KEY_META_DATA_VERSION) ?: ""
        return sdkVersion
    }
}