/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.resource.RedisType;

public class CamelliaRedisProxyResource
extends Resource {
    private final String password;
    private final String proxyName;
    private final long bid;
    private final String bgroup;
    private final int db;

    public CamelliaRedisProxyResource(String password, String proxyName) {
        this(password, proxyName, -1L, "default");
    }

    public CamelliaRedisProxyResource(String password, String proxyName, long bid, String bgroup) {
        this(password, proxyName, bid, bgroup, -1);
    }

    public CamelliaRedisProxyResource(String password, String proxyName, long bid, String bgroup, int db) {
        this.password = password;
        this.proxyName = proxyName;
        this.bid = bid;
        this.bgroup = bgroup;
        this.db = db;
        StringBuilder url = new StringBuilder();
        url.append(RedisType.CamelliaRedisProxy.getPrefix());
        if (password != null) {
            url.append(password);
        }
        url.append("@");
        url.append(proxyName);
        url.append("?");
        if (bid > 0L && bgroup != null) {
            url.append("bid=").append(bid).append("&");
            url.append("bgroup=").append(bgroup).append("&");
        }
        if (db > 0) {
            url.append("db=").append(db);
        }
        if (url.charAt(url.length() - 1) == '?' || url.charAt(url.length() - 1) == '&') {
            url.deleteCharAt(url.length() - 1);
        }
        this.setUrl(url.toString());
    }

    public long getBid() {
        return this.bid;
    }

    public String getBgroup() {
        return this.bgroup;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public int getDb() {
        return this.db;
    }
}

