/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.resource.RedisType;
import java.util.List;

public class RedisClusterResource
extends Resource {
    private final List<Node> nodes;
    private final String password;
    private final String userName;

    public RedisClusterResource(List<Node> nodes, String userName, String password) {
        this.nodes = nodes;
        this.password = password;
        this.userName = userName;
        StringBuilder url = new StringBuilder();
        url.append(RedisType.RedisCluster.getPrefix());
        if (userName != null && password != null) {
            url.append(userName).append(":").append(password);
        } else if (userName == null && password != null) {
            url.append(password);
        }
        url.append("@");
        for (Node node : nodes) {
            url.append(node.getHost()).append(":").append(node.getPort());
            url.append(",");
        }
        url.deleteCharAt(url.length() - 1);
        this.setUrl(url.toString());
    }

    public RedisClusterResource(List<Node> nodes, String password) {
        this(nodes, null, password);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public static class Node {
        private final String host;
        private final int port;

        public Node(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

