/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.resource.RedisClusterResource;
import com.netease.nim.camellia.redis.base.resource.RedisType;
import java.util.List;

public class RedisClusterSlavesResource
extends Resource {
    private final List<RedisClusterResource.Node> nodes;
    private final String password;
    private final boolean withMaster;
    private final String userName;

    public RedisClusterSlavesResource(List<RedisClusterResource.Node> nodes, String userName, String password, boolean withMaster) {
        this.nodes = nodes;
        this.password = password;
        this.withMaster = withMaster;
        this.userName = userName;
        StringBuilder url = new StringBuilder();
        url.append(RedisType.RedisClusterSlaves.getPrefix());
        if (userName != null && password != null) {
            url.append(userName).append(":").append(password);
        } else if (userName == null && password != null) {
            url.append(password);
        }
        url.append("@");
        for (RedisClusterResource.Node node : nodes) {
            url.append(node.getHost()).append(":").append(node.getPort());
            url.append(",");
        }
        url.deleteCharAt(url.length() - 1);
        url.append("?withMaster=").append(withMaster);
        this.setUrl(url.toString());
    }

    public List<RedisClusterResource.Node> getNodes() {
        return this.nodes;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isWithMaster() {
        return this.withMaster;
    }

    public String getUserName() {
        return this.userName;
    }
}

