/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.resource.RedisType;

public class RedisProxiesDiscoveryResource
extends Resource {
    private final String userName;
    private final String password;
    private final String proxyName;
    private final int db;

    public RedisProxiesDiscoveryResource(String userName, String password, String proxyName, int db) {
        this.userName = userName;
        this.password = password;
        this.proxyName = proxyName;
        this.db = db;
        StringBuilder url = new StringBuilder();
        url.append(RedisType.RedisProxiesDiscovery.getPrefix());
        if (userName != null && password != null) {
            url.append(userName).append(":").append(password);
        } else if (userName == null && password != null) {
            url.append(password);
        }
        url.append("@");
        url.append(proxyName);
        if (db > 0) {
            url.append("?db=").append(db);
        }
        this.setUrl(url.toString());
    }

    public RedisProxiesDiscoveryResource(String userName, String password, String proxyName) {
        this(userName, password, proxyName, 0);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public int getDb() {
        return this.db;
    }
}

